/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.unbiz.fluentvalidator.util;

import com.baidu.unbiz.fluentvalidator.exception.RuntimeValidateException;
import com.baidu.unbiz.fluentvalidator.util.CollectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ReflectionUtil {
    private static final String GETTER_METHOD_PREFIX = "get";
    private static final String GETTER_METHOD_PREFIX_FOR_BOOLEAN = "is";

    static List<Field> getAllFieldsOfClass0(Class<?> clazz) {
        ArrayList<Field> fields = CollectionUtil.createArrayList();
        Class<?> itr = clazz;
        while (ReflectionUtil.hasSuperClass(itr)) {
            fields.addAll(Arrays.asList(itr.getDeclaredFields()));
            itr = itr.getSuperclass();
        }
        return fields;
    }

    public static Field[] getAnnotationFields(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        if (clazz == null || annotationClass == null) {
            return null;
        }
        List<Field> fields = ReflectionUtil.getAllFieldsOfClass0(clazz);
        if (CollectionUtil.isEmpty(fields)) {
            return null;
        }
        ArrayList<Field> list = CollectionUtil.createArrayList();
        for (Field field : fields) {
            if (null == field.getAnnotation(annotationClass)) continue;
            list.add(field);
            field.setAccessible(true);
        }
        return list.toArray(new Field[0]);
    }

    public static <A extends Annotation> A getAnnotation(Field field, Class<A> annotationType) {
        if (field == null || annotationType == null) {
            return null;
        }
        return field.getAnnotation(annotationType);
    }

    public static boolean hasSuperClass(Class<?> clazz) {
        return clazz != null && !clazz.equals(Object.class);
    }

    public static Method getGetterMethod(Class<?> clazz, Field field) {
        return ReflectionUtil.getMethod(clazz, ReflectionUtil.getGetterMethodName(field), new Class[0]);
    }

    public static String getGetterMethodName(Field field) {
        String fieldName = field.getName();
        String prefix = field.getType() != Boolean.TYPE || field.getType() != Boolean.class ? GETTER_METHOD_PREFIX : GETTER_METHOD_PREFIX_FOR_BOOLEAN;
        return prefix + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        if (clazz == null || methodName == null || methodName.length() == 0) {
            return null;
        }
        Class<?> itr = clazz;
        while (ReflectionUtil.hasSuperClass(itr)) {
            Method[] methods;
            for (Method method : methods = itr.getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || !Arrays.equals(method.getParameterTypes(), parameterTypes)) continue;
                return method;
            }
            itr = itr.getSuperclass();
        }
        return null;
    }

    public static <T> T invokeMethod(Method method, Object target, Object ... args) {
        if (method == null) {
            return null;
        }
        method.setAccessible(true);
        try {
            Object result = method.invoke(target, args);
            return (T)result;
        }
        catch (Exception e) {
            throw new RuntimeValidateException(e);
        }
    }
}

