/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.cglib.beans.BeanMap;

public class BeanUtils {
    public static <T> Map<String, Object> beanToMap(T bean) {
        if (bean != null) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            BeanMap beanMap = BeanMap.create(bean);
            for (Object key : beanMap.keySet()) {
                map.put(String.valueOf(key), beanMap.get(key));
            }
            return map;
        }
        return null;
    }

    public static <T> T mapToBean(Map<String, Object> map, Class<T> clazz) {
        T bean = null;
        try {
            bean = clazz.newInstance();
            BeanMap.create(bean).putAll(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bean;
    }

    public static <T> List<Map<String, Object>> beansToMaps(List<T> beanList) {
        if (CollectionUtils.isEmpty(beanList)) {
            return null;
        }
        return beanList.stream().map(BeanUtils::beanToMap).collect(Collectors.toList());
    }

    public static <T> List<T> mapsToBeans(List<Map<String, Object>> maps, Class<T> clazz) {
        if (CollectionUtils.isNotEmpty(maps)) {
            return null;
        }
        return maps.stream().map(e -> BeanUtils.mapToBean(e, clazz)).collect(Collectors.toList());
    }
}

