/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.api;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.api.IErrorCode;
import com.baomidou.mybatisplus.extension.exceptions.ApiException;
import java.util.Collection;
import java.util.Map;

public class ApiAssert {
    protected ApiAssert() {
    }

    public static void gtZero(Integer num, IErrorCode errorCode) {
        if (num == null || num <= 0) {
            ApiAssert.fail(errorCode);
        }
    }

    public static void geZero(Integer num, IErrorCode errorCode) {
        if (num == null || num < 0) {
            ApiAssert.fail(errorCode);
        }
    }

    public static void gt(Integer num1, Integer num2, IErrorCode errorCode) {
        if (num1 <= num2) {
            ApiAssert.fail(errorCode);
        }
    }

    public static void ge(Integer num1, Integer num2, IErrorCode errorCode) {
        if (num1 < num2) {
            ApiAssert.fail(errorCode);
        }
    }

    public static void eq(Object obj1, Object obj2, IErrorCode errorCode) {
        if (!obj1.equals(obj2)) {
            ApiAssert.fail(errorCode);
        }
    }

    public static void isTrue(boolean condition, IErrorCode errorCode) {
        if (!condition) {
            ApiAssert.fail(errorCode);
        }
    }

    public static void isFalse(boolean condition, IErrorCode errorCode) {
        if (condition) {
            ApiAssert.fail(errorCode);
        }
    }

    public static void isNull(IErrorCode errorCode, Object ... conditions) {
        if (ObjectUtils.isNotNull((Object[])conditions)) {
            ApiAssert.fail(errorCode);
        }
    }

    public static void notNull(IErrorCode errorCode, Object ... conditions) {
        if (ObjectUtils.isNull((Object[])conditions)) {
            ApiAssert.fail(errorCode);
        }
    }

    public static void fail(IErrorCode errorCode) {
        throw new ApiException(errorCode);
    }

    public static void fail(boolean condition, IErrorCode errorCode) {
        if (condition) {
            ApiAssert.fail(errorCode);
        }
    }

    public static void fail(String message) {
        throw new ApiException(message);
    }

    public static void fail(boolean condition, String message) {
        if (condition) {
            ApiAssert.fail(message);
        }
    }

    public static void notEmpty(Object[] array, IErrorCode errorCode) {
        if (ObjectUtils.isEmpty((Object)array)) {
            ApiAssert.fail(errorCode);
        }
    }

    public static void noNullElements(Object[] array, IErrorCode errorCode) {
        if (array != null) {
            for (Object element : array) {
                if (element != null) continue;
                ApiAssert.fail(errorCode);
            }
        }
    }

    public static void notEmpty(Collection<?> collection, IErrorCode errorCode) {
        if (CollectionUtils.isNotEmpty(collection)) {
            ApiAssert.fail(errorCode);
        }
    }

    public static void notEmpty(Map<?, ?> map, IErrorCode errorCode) {
        if (ObjectUtils.isEmpty(map)) {
            ApiAssert.fail(errorCode);
        }
    }

    public static void isInstanceOf(Class<?> type, Object obj, IErrorCode errorCode) {
        ApiAssert.notNull(errorCode, type);
        if (!type.isInstance(obj)) {
            ApiAssert.fail(errorCode);
        }
    }

    public static void isAssignable(Class<?> superType, Class<?> subType, IErrorCode errorCode) {
        ApiAssert.notNull(errorCode, superType);
        if (subType == null || !superType.isAssignableFrom(subType)) {
            ApiAssert.fail(errorCode);
        }
    }
}

