/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.injector;

import com.baomidou.mybatisplus.core.injector.AbstractMethod;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.util.List;

public abstract class LogicAbstractMethod
extends AbstractMethod {
    public String getLogicDeleteSql(TableInfo table) {
        StringBuilder sql = new StringBuilder();
        List fieldList = table.getFieldList();
        for (TableFieldInfo fieldInfo : fieldList) {
            if (!fieldInfo.isLogicDelete()) continue;
            sql.append(" AND ").append(fieldInfo.getColumn());
            if (StringUtils.isCharSequence((Class)fieldInfo.getPropertyType()).booleanValue()) {
                sql.append("='").append(fieldInfo.getLogicNotDeleteValue()).append("'");
                continue;
            }
            sql.append("=").append(fieldInfo.getLogicNotDeleteValue());
        }
        return sql.toString();
    }

    protected String sqlLogicSet(TableInfo table) {
        List fieldList = table.getFieldList();
        StringBuilder set = new StringBuilder("SET ");
        int i = 0;
        for (TableFieldInfo fieldInfo : fieldList) {
            if (!fieldInfo.isLogicDelete()) continue;
            if (++i > 1) {
                set.append(",");
            }
            set.append(fieldInfo.getColumn()).append("=");
            if (StringUtils.isCharSequence((Class)fieldInfo.getPropertyType()).booleanValue()) {
                set.append("'").append(fieldInfo.getLogicDeleteValue()).append("'");
                continue;
            }
            set.append(fieldInfo.getLogicDeleteValue());
        }
        return set.toString();
    }

    protected String sqlWhereEntityWrapper(TableInfo table) {
        if (table.isLogicDelete()) {
            StringBuilder where = new StringBuilder(128);
            where.append("<where>");
            where.append("<choose><when test=\"ew!=null\">");
            where.append("<if test=\"ew.entity!=null\">");
            if (StringUtils.isNotEmpty((CharSequence)table.getKeyProperty())) {
                where.append("<if test=\"ew.entity.").append(table.getKeyProperty()).append("!=null\">");
                where.append(" AND ").append(table.getKeyColumn()).append("=#{ew.entity.");
                where.append(table.getKeyProperty()).append("}");
                where.append("</if>");
            }
            List fieldList = table.getFieldList();
            for (TableFieldInfo fieldInfo : fieldList) {
                where.append(this.convertIfTag(fieldInfo, "ew.entity.", false));
                where.append(" AND ").append(this.sqlCondition(fieldInfo.getCondition(), fieldInfo.getColumn(), "ew.entity." + fieldInfo.getEl()));
                where.append(this.convertIfTag(fieldInfo, true));
            }
            where.append("</if>");
            where.append(this.getLogicDeleteSql(table));
            where.append("<if test=\"ew.sqlSegment!=null\">${ew.sqlSegment}</if>");
            where.append("</when><otherwise>");
            where.append(this.getLogicDeleteSql(table));
            where.append("</otherwise></choose>");
            where.append("</where>");
            return where.toString();
        }
        return super.sqlWhereEntityWrapper(table);
    }

    protected String sqlWhereByMap(TableInfo table) {
        if (table.isLogicDelete()) {
            StringBuilder where = new StringBuilder();
            where.append("<where>");
            where.append("<if test=\"cm!=null and !cm.isEmpty\">");
            where.append("<foreach collection=\"cm.keys\" item=\"k\" separator=\"AND\">");
            where.append("<if test=\"cm[k] != null\">");
            where.append("${k} = #{cm[${k}]}");
            where.append("</if>");
            where.append("</foreach>");
            where.append("</if>");
            where.append(this.getLogicDeleteSql(table));
            where.append("</where>");
            return where.toString();
        }
        return super.sqlWhereByMap(table);
    }
}

