/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.pagination;

import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

public class PageHelper {
    private static final ThreadLocal<IPage> LOCAL_PAGE = new ThreadLocal();

    public static Long getTotal() {
        if (PageHelper.isPageable()) {
            return LOCAL_PAGE.get().getTotal();
        }
        throw new MybatisPlusException("The current thread does not start paging. Please call before PageHelper.startPage");
    }

    public static Long freeTotal() {
        Long total = PageHelper.getTotal();
        PageHelper.remove();
        return total;
    }

    public static long offsetCurrent(long current, long size) {
        if (current > 0L) {
            return (current - 1L) * size;
        }
        return 0L;
    }

    public static long offsetCurrent(IPage page) {
        if (null == page) {
            return 0L;
        }
        return PageHelper.offsetCurrent(page.getCurrent(), page.getSize());
    }

    public static IPage getPage() {
        return LOCAL_PAGE.get();
    }

    public static void setPage(IPage page) {
        LOCAL_PAGE.set(page);
    }

    public static void startPage(long current, long size) {
        LOCAL_PAGE.set(new Page(current, size));
    }

    public static boolean isPageable() {
        return LOCAL_PAGE.get() != null;
    }

    public static void remove() {
        LOCAL_PAGE.remove();
    }
}

