/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.handler.sharding;

import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.extension.plugins.handler.sharding.ShardingNode;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.AllComparisonExpression;
import net.sf.jsqlparser.expression.AnyComparisonExpression;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.CastExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.JdbcNamedParameter;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import net.sf.jsqlparser.expression.operators.arithmetic.Division;
import net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.Matches;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.util.TablesNamesFinder;

public class ShardingNodeExtractor
extends TablesNamesFinder {
    private final List<ShardingNode<Table, ShardingNode<String, Integer>>> nodes = new ArrayList<ShardingNode<Table, ShardingNode<String, Integer>>>();
    private Column currentColumn;

    public ShardingNodeExtractor(Statement statement) {
        super.getTableList(statement);
    }

    public void visit(Table table) {
        this.nodes.add(new ShardingNode(table, new ArrayList()));
    }

    public void visit(Column column) {
        this.currentColumn = column;
        ShardingNode<Table, ShardingNode<String, Integer>> tableNode = this.obtainTableNode(column);
        if (null == tableNode) {
            throw ExceptionUtils.mpe((String)"please determine the alias on sql", (Object[])new Object[0]);
        }
        ShardingNode columnNode = tableNode.getList().stream().filter(i -> ((String)i.getNode()).equals(column.getColumnName())).findFirst().orElse(null);
        if (null == columnNode) {
            tableNode.getList().add(new ShardingNode(column.getColumnName(), new ArrayList()));
        }
    }

    public void visit(Insert insert) {
        ExpressionList itemsList;
        this.visit(insert.getTable());
        if (insert.getColumns() != null && insert.getItemsList() != null && insert.getItemsList() instanceof ExpressionList && null != (itemsList = (ExpressionList)insert.getItemsList()).getExpressions() && insert.getColumns().size() == itemsList.getExpressions().size()) {
            for (int i = 0; i < insert.getColumns().size(); ++i) {
                Expression expression = (Expression)itemsList.getExpressions().get(i);
                if (!(expression instanceof JdbcParameter)) continue;
                this.visit((Column)insert.getColumns().get(i));
                this.visit((JdbcParameter)expression);
            }
        }
        if (insert.getSelect() != null) {
            this.visit(insert.getSelect());
        }
    }

    public void visit(Update update) {
        this.visit(update.getTable());
        if (update.getStartJoins() != null) {
            for (Join join : update.getStartJoins()) {
                join.getRightItem().accept((FromItemVisitor)this);
            }
        }
        if (update.getFromItem() != null) {
            update.getFromItem().accept((FromItemVisitor)this);
        }
        if (update.getJoins() != null) {
            for (Join join : update.getJoins()) {
                join.getRightItem().accept((FromItemVisitor)this);
            }
        }
        if (update.getWhere() != null) {
            update.getWhere().accept((ExpressionVisitor)this);
        }
    }

    public void visit(JdbcParameter jdbcParameter) {
        ShardingNode<Table, ShardingNode<String, Integer>> tableNode = this.obtainTableNode(this.currentColumn);
        if (null == tableNode) {
            throw ExceptionUtils.mpe((String)"please determine the alias on sql", (Object[])new Object[0]);
        }
        ShardingNode columnNode = tableNode.getList().stream().filter(i -> ((String)i.getNode()).equals(this.currentColumn.getColumnName())).findFirst().orElse(null);
        if (null == columnNode) {
            throw ExceptionUtils.mpe((String)"please determine the alias on sql", (Object[])new Object[0]);
        }
        columnNode.getList().add(jdbcParameter.getIndex());
    }

    public void visit(ExpressionList expressionList) {
        for (Expression expression : expressionList.getExpressions()) {
            expression.accept((ExpressionVisitor)this);
        }
    }

    private ShardingNode<Table, ShardingNode<String, Integer>> obtainTableNode(Column column) {
        return null == column || null == column.getTable() || null == column.getTable().getName() ? this.nodes.get(0) : (ShardingNode)this.nodes.stream().filter(i -> ((Table)i.getNode()).getAlias().getName().equals(column.getTable().getName())).findFirst().orElse(null);
    }

    public void visit(JdbcNamedParameter jdbcNamedParameter) {
    }

    public void visit(Parenthesis parenthesis) {
        parenthesis.getExpression().accept((ExpressionVisitor)this);
    }

    public void visit(Addition addition) {
        this.visitBinaryExpression((BinaryExpression)addition);
    }

    public void visit(Division division) {
        this.visitBinaryExpression((BinaryExpression)division);
    }

    public void visit(Subtraction subtraction) {
        this.visitBinaryExpression((BinaryExpression)subtraction);
    }

    public void visit(AndExpression andExpression) {
        this.visitBinaryExpression((BinaryExpression)andExpression);
    }

    public void visit(OrExpression orExpression) {
        this.visitBinaryExpression((BinaryExpression)orExpression);
    }

    public void visit(Between between) {
        between.getLeftExpression().accept((ExpressionVisitor)this);
        between.getBetweenExpressionStart().accept((ExpressionVisitor)this);
        between.getBetweenExpressionEnd().accept((ExpressionVisitor)this);
    }

    public void visit(EqualsTo equalsTo) {
        this.visitBinaryExpression((BinaryExpression)equalsTo);
    }

    public void visit(GreaterThan greaterThan) {
        this.visitBinaryExpression((BinaryExpression)greaterThan);
    }

    public void visit(GreaterThanEquals greaterThanEquals) {
        this.visitBinaryExpression((BinaryExpression)greaterThanEquals);
    }

    public void visit(InExpression inExpression) {
        inExpression.getLeftExpression().accept((ExpressionVisitor)this);
        if (null != inExpression.getLeftExpression()) {
            inExpression.getLeftExpression().accept((ExpressionVisitor)this);
        }
        if (null != inExpression.getRightItemsList()) {
            inExpression.getRightItemsList().accept((ItemsListVisitor)this);
        }
    }

    public void visit(LikeExpression likeExpression) {
        this.visitBinaryExpression((BinaryExpression)likeExpression);
    }

    public void visit(MinorThan minorThan) {
        this.visitBinaryExpression((BinaryExpression)minorThan);
    }

    public void visit(MinorThanEquals minorThanEquals) {
        this.visitBinaryExpression((BinaryExpression)minorThanEquals);
    }

    public void visit(NotEqualsTo notEqualsTo) {
        this.visitBinaryExpression((BinaryExpression)notEqualsTo);
    }

    public void visit(ExistsExpression existsExpression) {
        existsExpression.getRightExpression().accept((ExpressionVisitor)this);
    }

    public void visit(AllComparisonExpression allComparisonExpression) {
        allComparisonExpression.getSubSelect().getSelectBody().accept((SelectVisitor)this);
    }

    public void visit(AnyComparisonExpression anyComparisonExpression) {
        anyComparisonExpression.getSubSelect().getSelectBody().accept((SelectVisitor)this);
    }

    public void visit(Concat concat) {
        this.visitBinaryExpression((BinaryExpression)concat);
    }

    public void visit(Matches matches) {
        this.visitBinaryExpression((BinaryExpression)matches);
    }

    public void visit(BitwiseAnd bitwiseAnd) {
        this.visitBinaryExpression((BinaryExpression)bitwiseAnd);
    }

    public void visit(BitwiseOr bitwiseOr) {
        this.visitBinaryExpression((BinaryExpression)bitwiseOr);
    }

    public void visit(BitwiseXor bitwiseXor) {
        this.visitBinaryExpression((BinaryExpression)bitwiseXor);
    }

    public void visit(CastExpression cast) {
    }

    public void visit(SubSelect subSelect) {
        subSelect.getSelectBody().accept((SelectVisitor)this);
    }

    public void visit(SubJoin subjoin) {
        subjoin.getLeft().accept((FromItemVisitor)this);
        for (Join join : subjoin.getJoinList()) {
            join.getRightItem().accept((FromItemVisitor)this);
        }
    }

    public void visit(PlainSelect plainSelect) {
        plainSelect.getFromItem().accept((FromItemVisitor)this);
        if (plainSelect.getJoins() != null) {
            for (Join join : plainSelect.getJoins()) {
                join.getRightItem().accept((FromItemVisitor)this);
            }
        }
        if (plainSelect.getWhere() != null) {
            plainSelect.getWhere().accept((ExpressionVisitor)this);
        }
    }

    public List<ShardingNode<Table, ShardingNode<String, Integer>>> getNodes() {
        return this.nodes;
    }
}

