/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.handlers;

import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.extension.handlers.AbstractJsonTypeHandler;
import com.google.gson.Gson;
import java.lang.reflect.Field;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;

@MappedTypes(value={Object.class})
@MappedJdbcTypes(value={JdbcType.VARCHAR})
public class GsonTypeHandler
extends AbstractJsonTypeHandler<Object> {
    private static Gson GSON;

    public GsonTypeHandler(Class<?> type) {
        super(type);
    }

    public GsonTypeHandler(Class<?> type, Field field) {
        super(type, field);
    }

    public Object parse(String json) {
        return GsonTypeHandler.getGson().fromJson(json, this.getFieldType());
    }

    public String toJson(Object obj) {
        return GsonTypeHandler.getGson().toJson(obj);
    }

    public static Gson getGson() {
        if (null == GSON) {
            GSON = new Gson();
        }
        return GSON;
    }

    public static void setGson(Gson gson) {
        Assert.notNull((Object)gson, (String)"Gson should not be null", (Object[])new Object[0]);
        GSON = gson;
    }
}

