/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.indexes;

import com.basho.riak.client.api.commands.CoreFutureAdapter;
import com.basho.riak.client.api.commands.indexes.SecondaryIndexQuery;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.operations.SecondaryIndexQueryOperation;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.util.BinaryValue;
import java.util.ArrayList;
import java.util.List;

public class IntIndexQuery
extends SecondaryIndexQuery<Long, Response, IntIndexQuery> {
    private final SecondaryIndexQuery.IndexConverter<Long> converter = new SecondaryIndexQuery.IndexConverter<Long>(){

        @Override
        public Long convert(BinaryValue input) {
            return Long.valueOf(input.toStringUtf8());
        }

        @Override
        public BinaryValue convert(Long input) {
            return BinaryValue.createFromUtf8(String.valueOf(input));
        }
    };

    @Override
    protected SecondaryIndexQuery.IndexConverter<Long> getConverter() {
        return this.converter;
    }

    protected IntIndexQuery(Init<Long, ?> builder) {
        super(builder);
    }

    @Override
    protected RiakFuture<Response, IntIndexQuery> executeAsync(RiakCluster cluster) {
        RiakFuture<SecondaryIndexQueryOperation.Response, SecondaryIndexQueryOperation.Query> coreFuture = this.executeCoreAsync(cluster);
        IntQueryFuture future = new IntQueryFuture(coreFuture);
        coreFuture.addListener(future);
        return future;
    }

    public static class Response
    extends SecondaryIndexQuery.Response<Long> {
        protected Response(Namespace queryLocation, SecondaryIndexQueryOperation.Response coreResponse, SecondaryIndexQuery.IndexConverter<Long> converter) {
            super(queryLocation, coreResponse, converter);
        }

        @Override
        public List<Entry> getEntries() {
            ArrayList<Entry> convertedList = new ArrayList<Entry>();
            for (SecondaryIndexQueryOperation.Response.Entry e : this.coreResponse.getEntryList()) {
                Location loc = this.getLocationFromCoreEntry(e);
                Entry ce = new Entry(loc, e.getIndexKey(), this.converter);
                convertedList.add(ce);
            }
            return convertedList;
        }

        public class Entry
        extends SecondaryIndexQuery.Response.Entry<Long> {
            protected Entry(Location riakObjectLocation, BinaryValue indexKey, SecondaryIndexQuery.IndexConverter<Long> converter) {
                super(riakObjectLocation, indexKey, converter);
            }
        }
    }

    public static class Builder
    extends Init<Long, Builder> {
        public Builder(Namespace namespace, String indexName, Long start, Long end) {
            super(namespace, indexName, start, end);
        }

        public Builder(Namespace namespace, String indexName, Long match) {
            super(namespace, indexName, match);
        }

        @Override
        protected Builder self() {
            return this;
        }

        public IntIndexQuery build() {
            return new IntIndexQuery(this);
        }
    }

    protected static abstract class Init<S, T extends Init<S, T>>
    extends SecondaryIndexQuery.Init<S, T> {
        public Init(Namespace namespace, String indexName, S start, S end) {
            super(namespace, indexName + (Object)((Object)SecondaryIndexQuery.Type._INT), start, end);
        }

        public Init(Namespace namespace, String indexName, S match) {
            super(namespace, indexName + (Object)((Object)SecondaryIndexQuery.Type._INT), match);
        }

        @Override
        public T withRegexTermFilter(String filter) {
            throw new IllegalArgumentException("Cannot use term filter with _int query");
        }
    }

    protected final class IntQueryFuture
    extends CoreFutureAdapter<Response, IntIndexQuery, SecondaryIndexQueryOperation.Response, SecondaryIndexQueryOperation.Query> {
        public IntQueryFuture(RiakFuture<SecondaryIndexQueryOperation.Response, SecondaryIndexQueryOperation.Query> coreFuture) {
            super(coreFuture);
        }

        @Override
        protected Response convertResponse(SecondaryIndexQueryOperation.Response coreResponse) {
            return new Response(IntIndexQuery.this.namespace, coreResponse, IntIndexQuery.this.converter);
        }

        @Override
        protected IntIndexQuery convertQueryInfo(SecondaryIndexQueryOperation.Query coreQueryInfo) {
            return IntIndexQuery.this;
        }
    }
}

