/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.indexes;

import com.basho.riak.client.api.RiakCommand;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.operations.SecondaryIndexQueryOperation;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.util.BinaryValue;
import java.util.List;

public abstract class SecondaryIndexQuery<T, S, U>
extends RiakCommand<S, U> {
    protected final Namespace namespace;
    protected final String indexName;
    protected final BinaryValue continuation;
    protected final T match;
    protected final T start;
    protected final T end;
    protected final Integer maxResults;
    protected final boolean returnTerms;
    protected final boolean paginationSort;
    protected final String termFilter;
    protected Integer timeout;

    protected abstract IndexConverter<T> getConverter();

    protected SecondaryIndexQuery(Init<T, ?> builder) {
        this.namespace = ((Init)builder).namespace;
        this.indexName = ((Init)builder).indexName;
        this.continuation = ((Init)builder).continuation;
        this.match = ((Init)builder).match;
        this.start = ((Init)builder).start;
        this.end = ((Init)builder).end;
        this.maxResults = ((Init)builder).maxResults;
        this.returnTerms = ((Init)builder).returnTerms;
        this.paginationSort = ((Init)builder).paginationSort;
        this.termFilter = ((Init)builder).termFilter;
        this.timeout = ((Init)builder).timeout;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public T getMatchValue() {
        return this.match;
    }

    public T getRangeStart() {
        return this.start;
    }

    public T getRangeEnd() {
        return this.end;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public boolean getReturnKeyAndIndex() {
        return this.returnTerms;
    }

    public boolean getPaginationSort() {
        return this.paginationSort;
    }

    public String getTermFilter() {
        return this.termFilter;
    }

    public BinaryValue getContinuation() {
        return this.continuation;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    protected final SecondaryIndexQueryOperation.Query createCoreQuery() {
        IndexConverter<T> converter = this.getConverter();
        SecondaryIndexQueryOperation.Query.Builder coreQueryBuilder = new SecondaryIndexQueryOperation.Query.Builder(this.namespace, BinaryValue.create(this.indexName)).withContinuation(this.continuation).withReturnKeyAndIndex(this.returnTerms).withPaginationSort(this.paginationSort);
        if (this.termFilter != null) {
            coreQueryBuilder.withRegexTermFilter(BinaryValue.create(this.termFilter));
        }
        if (this.match != null) {
            coreQueryBuilder.withIndexKey(converter.convert(this.match));
        } else {
            coreQueryBuilder.withRangeStart(converter.convert(this.start)).withRangeEnd(converter.convert(this.end));
        }
        if (this.maxResults != null) {
            coreQueryBuilder.withMaxResults(this.maxResults);
        }
        if (this.timeout != null) {
            coreQueryBuilder.withTimeout(this.timeout);
        }
        return coreQueryBuilder.build();
    }

    protected RiakFuture<SecondaryIndexQueryOperation.Response, SecondaryIndexQueryOperation.Query> executeCoreAsync(RiakCluster cluster) {
        SecondaryIndexQueryOperation.Builder builder = new SecondaryIndexQueryOperation.Builder(this.createCoreQuery());
        return cluster.execute(builder.build());
    }

    public static abstract class Response<T> {
        final IndexConverter<T> converter;
        final SecondaryIndexQueryOperation.Response coreResponse;
        final Namespace queryLocation;

        protected Response(Namespace queryLocation, SecondaryIndexQueryOperation.Response coreResponse, IndexConverter<T> converter) {
            this.coreResponse = coreResponse;
            this.converter = converter;
            this.queryLocation = queryLocation;
        }

        public boolean hasContinuation() {
            return this.coreResponse.hasContinuation();
        }

        public BinaryValue getContinuation() {
            return this.coreResponse.getContinuation();
        }

        public boolean hasEntries() {
            return !this.coreResponse.getEntryList().isEmpty();
        }

        protected final Location getLocationFromCoreEntry(SecondaryIndexQueryOperation.Response.Entry e) {
            Location loc = new Location(this.queryLocation, e.getObjectKey());
            return loc;
        }

        public abstract List<?> getEntries();

        public static abstract class Entry<T> {
            private final Location RiakObjectLocation;
            private final BinaryValue indexKey;
            private final IndexConverter<T> converter;

            protected Entry(Location riakObjectLocation, BinaryValue indexKey, IndexConverter<T> converter) {
                this.RiakObjectLocation = riakObjectLocation;
                this.indexKey = indexKey;
                this.converter = converter;
            }

            public Location getRiakObjectLocation() {
                return this.RiakObjectLocation;
            }

            public T getIndexKey() {
                return this.converter.convert(this.indexKey);
            }
        }
    }

    public static abstract class Init<S, T extends Init<S, T>> {
        private final Namespace namespace;
        private final String indexName;
        private volatile BinaryValue continuation;
        private volatile S match;
        private volatile S start;
        private volatile S end;
        private volatile Integer maxResults;
        private volatile boolean returnTerms;
        private volatile boolean paginationSort;
        private volatile String termFilter;
        private volatile Integer timeout;

        protected abstract T self();

        public Init(Namespace namespace, String indexName, S start, S end) {
            this.namespace = namespace;
            this.indexName = indexName;
            this.start = start;
            this.end = end;
        }

        public Init(Namespace namespace, String indexName, S match) {
            this.namespace = namespace;
            this.indexName = indexName;
            this.match = match;
        }

        public T withContinuation(BinaryValue continuation) {
            this.continuation = continuation;
            return this.self();
        }

        public T withMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this.self();
        }

        public T withKeyAndIndex(boolean returnBoth) {
            this.returnTerms = returnBoth;
            return this.self();
        }

        public T withPaginationSort(boolean orderByKey) {
            this.paginationSort = orderByKey;
            return this.self();
        }

        public T withRegexTermFilter(String filter) {
            this.termFilter = filter;
            return this.self();
        }

        public T withTimeout(int timeout) {
            this.timeout = timeout;
            return this.self();
        }
    }

    protected static interface IndexConverter<T> {
        public T convert(BinaryValue var1);

        public BinaryValue convert(T var1);
    }

    public static enum Type {
        _INT("_int"),
        _BIN("_bin"),
        _BUCKET(""),
        _KEY("");

        private String suffix;

        private Type(String suffix) {
            this.suffix = suffix;
        }

        public String toString() {
            return this.suffix;
        }
    }
}

