/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations;

import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.RiakMessage;
import com.basho.riak.client.core.converters.CrdtResponseConverter;
import com.basho.riak.client.core.operations.DtFetchOperation;
import com.basho.riak.client.core.operations.Operations;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.query.crdt.ops.CounterOp;
import com.basho.riak.client.core.query.crdt.ops.CrdtOp;
import com.basho.riak.client.core.query.crdt.ops.FlagOp;
import com.basho.riak.client.core.query.crdt.ops.MapOp;
import com.basho.riak.client.core.query.crdt.ops.RegisterOp;
import com.basho.riak.client.core.query.crdt.ops.SetOp;
import com.basho.riak.client.core.query.crdt.types.RiakDatatype;
import com.basho.riak.client.core.util.BinaryValue;
import java.util.List;
import shaded.com.basho.riak.protobuf.RiakDtPB;
import shaded.com.google.protobuf.ByteString;
import shaded.com.google.protobuf.InvalidProtocolBufferException;

public class DtUpdateOperation
extends FutureOperation<Response, RiakDtPB.DtUpdateResp, Location> {
    private final Location location;
    private final RiakDtPB.DtUpdateReq.Builder reqBuilder;

    private DtUpdateOperation(Builder builder) {
        this.reqBuilder = builder.reqBuilder;
        this.location = builder.location;
    }

    @Override
    protected Response convert(List<RiakDtPB.DtUpdateResp> rawResponse) {
        if (rawResponse.size() != 1) {
            throw new IllegalStateException("Expecting exactly one response, instead received " + rawResponse.size());
        }
        RiakDtPB.DtUpdateResp response = rawResponse.iterator().next();
        CrdtResponseConverter converter = new CrdtResponseConverter();
        RiakDatatype element = converter.convert(response);
        Response.Builder responseBuilder = (Response.Builder)new Response.Builder().withCrdtElement(element);
        if (response.hasKey()) {
            BinaryValue key = BinaryValue.unsafeCreate(response.getKey().toByteArray());
            responseBuilder.withGeneratedKey(key);
        }
        if (response.hasContext()) {
            BinaryValue context = BinaryValue.unsafeCreate(response.getContext().toByteArray());
            responseBuilder.withContext(context);
        }
        return responseBuilder.build();
    }

    @Override
    protected RiakMessage createChannelMessage() {
        return new RiakMessage(82, this.reqBuilder.build().toByteArray());
    }

    @Override
    protected RiakDtPB.DtUpdateResp decode(RiakMessage rawMessage) {
        Operations.checkMessageType(rawMessage, (byte)83);
        try {
            RiakDtPB.DtUpdateResp resp = RiakDtPB.DtUpdateResp.parseFrom(rawMessage.getData());
            return resp;
        }
        catch (InvalidProtocolBufferException ex) {
            throw new IllegalArgumentException("Invalid message received", ex);
        }
    }

    @Override
    public Location getQueryInfo() {
        return this.location;
    }

    public static class Response
    extends DtFetchOperation.Response {
        private final BinaryValue generatedKey;

        private Response(Init<?> builder) {
            super(builder);
            this.generatedKey = ((Init)builder).generatedKey;
        }

        public boolean hasGeneratedKey() {
            return this.generatedKey != null;
        }

        public BinaryValue getGeneratedKey() {
            return this.generatedKey;
        }

        static class Builder
        extends Init<Builder> {
            Builder() {
            }

            @Override
            protected Builder self() {
                return this;
            }

            @Override
            protected Response build() {
                return new Response(this);
            }
        }

        protected static abstract class Init<T extends Init<T>>
        extends DtFetchOperation.Response.Init<T> {
            private BinaryValue generatedKey;

            protected Init() {
            }

            T withGeneratedKey(BinaryValue generatedKey) {
                this.generatedKey = generatedKey;
                return (T)((Init)this.self());
            }
        }
    }

    public static class Builder {
        private final RiakDtPB.DtUpdateReq.Builder reqBuilder = RiakDtPB.DtUpdateReq.newBuilder();
        private final Location location;
        private boolean removeOpPresent = false;

        public Builder(Location location) {
            if (location == null) {
                throw new IllegalArgumentException("Location cannot be null");
            }
            if (location.getNamespace().getBucketTypeAsString().equals("default")) {
                throw new IllegalArgumentException("Default bucket type does not accept CRDTs");
            }
            this.reqBuilder.setBucket(ByteString.copyFrom(location.getNamespace().getBucketName().unsafeGetValue()));
            this.reqBuilder.setType(ByteString.copyFrom(location.getNamespace().getBucketType().unsafeGetValue()));
            this.reqBuilder.setKey(ByteString.copyFrom(location.getKey().unsafeGetValue()));
            this.location = location;
        }

        public Builder(Namespace namespace) {
            if (namespace == null) {
                throw new IllegalArgumentException("Namespace cannot be null");
            }
            if (namespace.getBucketTypeAsString().equals("default")) {
                throw new IllegalArgumentException("Default bucket type does not accept CRDTs");
            }
            Location loc = new Location(namespace, "RIAK_GENERATED");
            this.reqBuilder.setBucket(ByteString.copyFrom(loc.getNamespace().getBucketName().unsafeGetValue()));
            this.reqBuilder.setType(ByteString.copyFrom(loc.getNamespace().getBucketType().unsafeGetValue()));
            this.location = loc;
        }

        public Builder withContext(BinaryValue ctx) {
            if (null == ctx) {
                throw new IllegalArgumentException("Context cannot be null.");
            }
            this.reqBuilder.setContext(ByteString.copyFrom(ctx.unsafeGetValue()));
            return this;
        }

        public Builder withW(int w) {
            this.reqBuilder.setW(w);
            return this;
        }

        public Builder withDw(int dw) {
            this.reqBuilder.setDw(dw);
            return this;
        }

        public Builder withPw(int pw) {
            this.reqBuilder.setPw(pw);
            return this;
        }

        public Builder withReturnBody(boolean returnBody) {
            this.reqBuilder.setReturnBody(returnBody);
            return this;
        }

        public Builder withTimeout(int timeout) {
            this.reqBuilder.setTimeout(timeout);
            return this;
        }

        public Builder withNVal(int nval) {
            this.reqBuilder.setNVal(nval);
            return this;
        }

        public Builder withSloppyQuorum(boolean sloppyQuorum) {
            this.reqBuilder.setSloppyQuorum(sloppyQuorum);
            return this;
        }

        public DtUpdateOperation build() {
            if (this.removeOpPresent && !this.reqBuilder.hasContext()) {
                throw new IllegalStateException("Remove operations cannot be performed without a context.");
            }
            return new DtUpdateOperation(this);
        }

        RiakDtPB.CounterOp getCounterOp(CounterOp op) {
            return RiakDtPB.CounterOp.newBuilder().setIncrement(op.getIncrement()).build();
        }

        RiakDtPB.SetOp getSetOp(SetOp op) {
            RiakDtPB.SetOp.Builder setOpBuilder = RiakDtPB.SetOp.newBuilder();
            for (BinaryValue element : op.getAdds()) {
                setOpBuilder.addAdds(ByteString.copyFrom(element.unsafeGetValue()));
            }
            for (BinaryValue element : op.getRemoves()) {
                setOpBuilder.addRemoves(ByteString.copyFrom(element.unsafeGetValue()));
            }
            if (setOpBuilder.getRemovesCount() > 0) {
                this.removeOpPresent = true;
            }
            return setOpBuilder.build();
        }

        RiakDtPB.MapUpdate.FlagOp getFlagOp(FlagOp op) {
            return op.getEnabled() ? RiakDtPB.MapUpdate.FlagOp.ENABLE : RiakDtPB.MapUpdate.FlagOp.DISABLE;
        }

        ByteString getRegisterOp(RegisterOp op) {
            return ByteString.copyFrom(op.getValue().unsafeGetValue());
        }

        RiakDtPB.MapField getMapField(MapOp.MapField field) {
            RiakDtPB.MapField.Builder mapFieldBuilder = RiakDtPB.MapField.newBuilder();
            switch (field.type) {
                case SET: {
                    mapFieldBuilder.setType(RiakDtPB.MapField.MapFieldType.SET);
                    break;
                }
                case REGISTER: {
                    mapFieldBuilder.setType(RiakDtPB.MapField.MapFieldType.REGISTER);
                    break;
                }
                case MAP: {
                    mapFieldBuilder.setType(RiakDtPB.MapField.MapFieldType.MAP);
                    break;
                }
                case FLAG: {
                    mapFieldBuilder.setType(RiakDtPB.MapField.MapFieldType.FLAG);
                    break;
                }
                case COUNTER: {
                    mapFieldBuilder.setType(RiakDtPB.MapField.MapFieldType.COUNTER);
                    break;
                }
            }
            mapFieldBuilder.setName(ByteString.copyFrom(field.key.unsafeGetValue()));
            return mapFieldBuilder.build();
        }

        RiakDtPB.MapOp getMapOp(MapOp op) {
            RiakDtPB.MapOp.Builder mapOpBuilder = RiakDtPB.MapOp.newBuilder();
            for (MapOp.MapField field : op.getRemoves()) {
                mapOpBuilder.addRemoves(this.getMapField(field));
            }
            if (mapOpBuilder.getRemovesCount() > 0) {
                this.removeOpPresent = true;
            }
            for (MapOp.MapUpdate update : op.getUpdates()) {
                RiakDtPB.MapUpdate.Builder mapUpdateBuilder = RiakDtPB.MapUpdate.newBuilder();
                switch (update.field.type) {
                    case COUNTER: {
                        mapUpdateBuilder.setCounterOp(this.getCounterOp((CounterOp)update.op));
                        break;
                    }
                    case FLAG: {
                        mapUpdateBuilder.setFlagOp(this.getFlagOp((FlagOp)update.op));
                        break;
                    }
                    case MAP: {
                        mapUpdateBuilder.setMapOp(this.getMapOp((MapOp)update.op));
                        break;
                    }
                    case REGISTER: {
                        mapUpdateBuilder.setRegisterOp(this.getRegisterOp((RegisterOp)update.op));
                        break;
                    }
                    case SET: {
                        mapUpdateBuilder.setSetOp(this.getSetOp((SetOp)update.op));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknow datatype encountered");
                    }
                }
                mapUpdateBuilder.setField(this.getMapField(update.field));
                mapOpBuilder.addUpdates(mapUpdateBuilder);
            }
            return mapOpBuilder.build();
        }

        public Builder withOp(CrdtOp op) {
            if (op instanceof CounterOp) {
                this.withOp((CounterOp)op);
            } else if (op instanceof MapOp) {
                this.withOp((MapOp)op);
            } else if (op instanceof SetOp) {
                this.withOp((SetOp)op);
            }
            return this;
        }

        private Builder withOp(CounterOp op) {
            this.reqBuilder.setOp(RiakDtPB.DtOp.newBuilder().setCounterOp(this.getCounterOp(op)));
            return this;
        }

        private Builder withOp(MapOp op) {
            this.reqBuilder.setOp(RiakDtPB.DtOp.newBuilder().setMapOp(this.getMapOp(op)));
            return this;
        }

        private Builder withOp(SetOp op) {
            this.reqBuilder.setOp(RiakDtPB.DtOp.newBuilder().setSetOp(this.getSetOp(op)));
            return this;
        }
    }
}

