/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.crdt.ops;

import com.basho.riak.client.core.query.crdt.ops.CounterOp;
import com.basho.riak.client.core.query.crdt.ops.CrdtOp;
import com.basho.riak.client.core.query.crdt.ops.FlagOp;
import com.basho.riak.client.core.query.crdt.ops.RegisterOp;
import com.basho.riak.client.core.query.crdt.ops.SetOp;
import com.basho.riak.client.core.util.BinaryValue;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class MapOp
implements CrdtOp {
    private final Set<MapField> removes;
    private final Set<MapUpdate> updates;

    public MapOp() {
        this.removes = new HashSet<MapField>();
        this.updates = new HashSet<MapUpdate>();
    }

    public MapOp(Set<MapField> removes, Set<MapUpdate> updates) {
        this.removes = removes;
        this.updates = updates;
    }

    private MapOp update(BinaryValue key, CrdtOp op, FieldType type) {
        MapField field = new MapField(type, key);
        MapUpdate update = new MapUpdate(field, op);
        this.updates.add(update);
        return this;
    }

    public MapOp update(BinaryValue key, SetOp op) {
        return this.update(key, op, FieldType.SET);
    }

    public MapOp update(BinaryValue key, CounterOp op) {
        return this.update(key, op, FieldType.COUNTER);
    }

    public MapOp update(BinaryValue key, MapOp op) {
        return this.update(key, op, FieldType.MAP);
    }

    public MapOp update(BinaryValue key, RegisterOp op) {
        return this.update(key, op, FieldType.REGISTER);
    }

    public MapOp update(BinaryValue key, FlagOp op) {
        return this.update(key, op, FieldType.FLAG);
    }

    public MapOp remove(BinaryValue key, FieldType type) {
        MapField field = new MapField(type, key);
        this.removes.add(field);
        return this;
    }

    public Set<MapField> getRemoves() {
        return Collections.unmodifiableSet(this.removes);
    }

    public Set<MapUpdate> getUpdates() {
        return Collections.unmodifiableSet(this.updates);
    }

    public static class MapUpdate {
        public final MapField field;
        public final CrdtOp op;

        public MapUpdate(MapField field, CrdtOp op) {
            this.field = field;
            this.op = op;
        }
    }

    public static class MapField {
        public final FieldType type;
        public final BinaryValue key;

        public MapField(FieldType type, BinaryValue key) {
            this.type = type;
            this.key = key;
        }
    }

    public static enum FieldType {
        SET,
        COUNTER,
        MAP,
        REGISTER,
        FLAG;

    }
}

