/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.timeseries;

public class ColumnDescription {
    private final String name;
    private final ColumnType type;

    public ColumnDescription(String name, ColumnType type) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Column Name must not be null or empty.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Column Type must not be null.");
        }
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public ColumnType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnDescription that = (ColumnDescription)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public static enum ColumnType {
        VARCHAR,
        SINT64,
        DOUBLE,
        TIMESTAMP,
        BOOLEAN;

    }
}

