/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.timeseries;

import com.basho.riak.client.core.query.timeseries.Cell;
import com.basho.riak.client.core.query.timeseries.ConvertibleIterable;
import com.basho.riak.client.core.query.timeseries.ConvertibleIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import shaded.com.basho.riak.protobuf.RiakTsPB;

public class Row
implements Iterable<Cell> {
    private final RiakTsPB.TsRow pbRow;

    public Row(Iterable<Cell> cells) {
        RiakTsPB.TsRow.Builder builder = RiakTsPB.TsRow.newBuilder();
        builder.addAllCells(ConvertibleIterable.asIterablePbCell(cells));
        this.pbRow = builder.build();
    }

    public Row(Cell ... cells) {
        RiakTsPB.TsRow.Builder builder = RiakTsPB.TsRow.newBuilder();
        builder.addAllCells(ConvertibleIterable.asIterablePbCell(Arrays.asList(cells)));
        this.pbRow = builder.build();
    }

    Row(RiakTsPB.TsRow pbRow) {
        this.pbRow = pbRow;
    }

    public int getCellsCount() {
        return this.pbRow.getCellsCount();
    }

    public List<Cell> getCellsCopy() {
        ArrayList<Cell> cells = new ArrayList<Cell>(this.getCellsCount());
        for (Cell c : this) {
            cells.add(c);
        }
        return cells;
    }

    RiakTsPB.TsRow getPbRow() {
        return this.pbRow;
    }

    @Override
    public Iterator<Cell> iterator() {
        return ConvertibleIterator.iterateAsCell(this.pbRow.getCellsList().iterator());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Row cells = (Row)o;
        return !(this.pbRow == null ? cells.pbRow != null : !this.pbRow.equals(cells.pbRow));
    }

    public int hashCode() {
        return this.pbRow != null ? this.pbRow.hashCode() : 0;
    }
}

