/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.util;

import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultCharset {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCharset.class);
    private static final DefaultCharset instance = DefaultCharset.initializeDefaultCharsetSingleton();
    private final AtomicReference<Charset> currentCharset;

    private DefaultCharset(Charset c) {
        logger.info("Initializing client charset to: {}", (Object)c.name());
        this.currentCharset = new AtomicReference<Charset>(c);
    }

    private static DefaultCharset initializeDefaultCharsetSingleton() {
        Charset charset;
        Charset systemDefault = Charset.defaultCharset();
        String declaredCharsetName = System.getProperty("com.basho.riak.client.DefaultCharset");
        if (declaredCharsetName != null && !declaredCharsetName.isEmpty()) {
            try {
                charset = Charset.forName(declaredCharsetName);
            }
            catch (Exception ex) {
                charset = systemDefault;
                logger.warn("Requested charset '{}' is not available, the default charset '{}' will be used", (Object)declaredCharsetName, (Object)charset.name());
            }
        } else {
            logger.info("No desired charset found in system properties, the default charset '{}' will be used", (Object)systemDefault.name());
            charset = systemDefault;
        }
        return new DefaultCharset(charset);
    }

    public static Charset get() {
        return DefaultCharset.instance.currentCharset.get();
    }

    public static void set(Charset charset) {
        Charset current = DefaultCharset.instance.currentCharset.get();
        logger.info("Setting client charset from '{}' to '{}'", (Object)current.name(), (Object)charset.name());
        DefaultCharset.instance.currentCharset.set(charset);
    }
}

