/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.util;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public final class HostAndPort
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final int port;
    private final String host;
    private transient InetSocketAddress inetAddress;

    private HostAndPort(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public boolean hasPort() {
        return this.port >= 0;
    }

    public int getPort() {
        return this.port;
    }

    public int getPortOrDefault(int defaultPort) {
        if (!this.hasPort()) {
            return defaultPort;
        }
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public InetSocketAddress asInetSocketAddress() {
        if (this.inetAddress == null) {
            this.inetAddress = new InetSocketAddress(this.getHost(), this.getPort());
        }
        return this.inetAddress;
    }

    public static List<HostAndPort> hostsFromString(String hostPortStr, int defaultPort) {
        HostAndPort.checkHost(hostPortStr);
        String[] rawHosts = hostPortStr.split(",");
        ArrayList<HostAndPort> retVal = new ArrayList<HostAndPort>(rawHosts.length);
        for (String s : rawHosts) {
            retVal.add(HostAndPort.fromString(s, defaultPort));
        }
        return retVal;
    }

    public static HostAndPort fromString(String hostPortStr, int defaultPort) {
        HostAndPort retVal;
        hostPortStr = hostPortStr.trim();
        HostAndPort.checkHost(hostPortStr);
        int idx = hostPortStr.indexOf(58);
        if (idx == -1) {
            retVal = HostAndPort.fromParts(hostPortStr, defaultPort);
        } else {
            try {
                retVal = HostAndPort.fromParts(hostPortStr.substring(0, idx), Integer.parseInt(hostPortStr.substring(idx + 1)));
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Unparseable port number: " + hostPortStr);
            }
        }
        return retVal;
    }

    public static HostAndPort fromParts(String host, int port) {
        HostAndPort.checkHost(host);
        return new HostAndPort(host, port);
    }

    private static void checkHost(String host) throws IllegalArgumentException {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("Host must be provided, it can't be null or empty");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostAndPort that = (HostAndPort)o;
        return this.getPort() == that.getPort() && this.getHost().equals(that.getHost());
    }

    public int hashCode() {
        int result = this.getPort();
        result = 31 * result + this.getHost().hashCode();
        return result;
    }

    public String toString() {
        return "HostAndPort{host='" + this.host + '\'' + ", port=" + this.port + '}';
    }
}

