/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.cap;

import com.basho.riak.client.api.cap.VClock;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;

public class BasicVClock
implements VClock {
    private final byte[] value;

    public BasicVClock(byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException("VClock value cannot be null");
        }
        this.value = Arrays.copyOf(value, value.length);
    }

    public BasicVClock(String vclock) {
        if (vclock == null) {
            throw new IllegalArgumentException("VClock value cannot be null");
        }
        this.value = vclock.getBytes(Charset.forName("UTF-8"));
    }

    @Override
    public byte[] getBytes() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    @Override
    public String asString() {
        try {
            return new String(this.value, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof VClock) {
            VClock other = (VClock)o;
            return Arrays.equals(other.getBytes(), this.value);
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Arrays.hashCode(this.value);
        return hash;
    }
}

