/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.datatypes;

import com.basho.riak.client.api.commands.CoreFutureAdapter;
import com.basho.riak.client.api.commands.datatypes.Context;
import com.basho.riak.client.api.commands.datatypes.MapUpdate;
import com.basho.riak.client.api.commands.datatypes.UpdateDatatype;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.RiakFutureListener;
import com.basho.riak.client.core.operations.DtUpdateOperation;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.query.crdt.types.RiakDatatype;
import com.basho.riak.client.core.query.crdt.types.RiakMap;
import com.basho.riak.client.core.util.BinaryValue;

public class UpdateMap
extends UpdateDatatype<RiakMap, Response, Location> {
    private final MapUpdate update;

    private UpdateMap(Builder builder) {
        super(builder);
        this.update = builder.update;
    }

    @Override
    protected RiakFuture<Response, Location> executeAsync(RiakCluster cluster) {
        RiakFuture<DtUpdateOperation.Response, Location> coreFuture = cluster.execute(this.buildCoreOperation(this.update));
        CoreFutureAdapter<Response, Location, DtUpdateOperation.Response, Location> future = new CoreFutureAdapter<Response, Location, DtUpdateOperation.Response, Location>(coreFuture){

            @Override
            protected Response convertResponse(DtUpdateOperation.Response coreResponse) {
                RiakMap map = null;
                if (coreResponse.hasCrdtElement()) {
                    RiakDatatype element = coreResponse.getCrdtElement();
                    map = element.getAsMap();
                }
                BinaryValue returnedKey = coreResponse.hasGeneratedKey() ? coreResponse.getGeneratedKey() : null;
                Context returnedCtx = null;
                if (coreResponse.hasContext()) {
                    returnedCtx = new Context(coreResponse.getContext());
                }
                return new Response(returnedCtx, map, returnedKey);
            }

            @Override
            protected Location convertQueryInfo(Location coreQueryInfo) {
                return coreQueryInfo;
            }
        };
        coreFuture.addListener((RiakFutureListener<DtUpdateOperation.Response, Location>)future);
        return future;
    }

    public static final class Builder
    extends UpdateDatatype.Builder<Builder> {
        private final MapUpdate update;

        public Builder(Location location, MapUpdate update) {
            super(location);
            if (update == null) {
                throw new IllegalArgumentException("Update cannot be null");
            }
            this.update = update;
        }

        public Builder(Namespace namespace, MapUpdate update) {
            super(namespace);
            if (update == null) {
                throw new IllegalArgumentException("Update cannot be null");
            }
            this.update = update;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateMap build() {
            return new UpdateMap(this);
        }
    }

    public static final class Response
    extends UpdateDatatype.Response<RiakMap> {
        private Response(Context context, RiakMap datatype, BinaryValue generatedKey) {
            super(context, datatype, generatedKey);
        }
    }
}

