/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.timeseries;

import com.basho.riak.client.api.RiakCommand;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.operations.ts.DeleteOperation;
import com.basho.riak.client.core.query.timeseries.Cell;

public class Delete
extends RiakCommand<Void, String> {
    private final Builder builder;

    private Delete(Builder builder) {
        this.builder = builder;
    }

    @Override
    protected RiakFuture<Void, String> executeAsync(RiakCluster cluster) {
        RiakFuture<Void, String> future = cluster.execute(this.buildCoreOperation());
        return future;
    }

    private DeleteOperation buildCoreOperation() {
        DeleteOperation.Builder opBuilder = new DeleteOperation.Builder(this.builder.tableName, this.builder.keyValues);
        if (this.builder.timeout > 0) {
            opBuilder.withTimeout(this.builder.timeout);
        }
        return opBuilder.build();
    }

    public static class Builder {
        private final String tableName;
        private final Iterable<Cell> keyValues;
        private int timeout;

        public Builder(String tableName, Iterable<Cell> keyValues) {
            if (tableName == null || tableName.length() == 0) {
                throw new IllegalArgumentException("Table Name cannot be null or an empty string.");
            }
            if (keyValues == null || !keyValues.iterator().hasNext()) {
                throw new IllegalArgumentException("Key Values cannot be null or an empty.");
            }
            this.tableName = tableName;
            this.keyValues = keyValues;
        }

        public Builder withTimeout(int timeout) {
            if (timeout < 0) {
                throw new IllegalArgumentException("Timeout must be positive, or 0 for no timeout.");
            }
            this.timeout = timeout;
            return this;
        }

        public Delete build() {
            return new Delete(this);
        }
    }
}

