/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.convert;

import com.basho.riak.client.api.cap.VClock;
import com.basho.riak.client.api.convert.ConversionException;
import com.basho.riak.client.api.convert.reflection.AnnotationUtil;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.query.RiakObject;
import com.basho.riak.client.core.util.BinaryValue;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class Converter<T> {
    protected final Type type;

    public Converter(Type type) {
        this.type = type;
    }

    protected final T newDomainInstance() {
        try {
            Class rawType = this.type instanceof Class ? (Class)this.type : (Class)((ParameterizedType)this.type).getRawType();
            Constructor constructor = rawType.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new ConversionException(ex);
        }
    }

    public T toDomain(RiakObject obj, Location location) {
        T domainObject;
        if (obj.isDeleted()) {
            domainObject = this.newDomainInstance();
        } else {
            domainObject = this.toDomain(obj.getValue(), obj.getContentType());
            AnnotationUtil.populateIndexes(obj.getIndexes(), domainObject);
            AnnotationUtil.populateLinks(obj.getLinks(), domainObject);
            AnnotationUtil.populateUsermeta(obj.getUserMeta(), domainObject);
            AnnotationUtil.setContentType(domainObject, obj.getContentType());
            AnnotationUtil.setVTag(domainObject, obj.getVTag());
        }
        AnnotationUtil.setKey(domainObject, location.getKey());
        AnnotationUtil.setBucketName(domainObject, location.getNamespace().getBucketName());
        AnnotationUtil.setBucketType(domainObject, location.getNamespace().getBucketType());
        AnnotationUtil.setVClock(domainObject, obj.getVClock());
        AnnotationUtil.setTombstone(domainObject, obj.isDeleted());
        AnnotationUtil.setLastModified(domainObject, obj.getLastModified());
        return domainObject;
    }

    public abstract T toDomain(BinaryValue var1, String var2) throws ConversionException;

    public OrmExtracted fromDomain(T domainObject, Namespace namespace, BinaryValue key) {
        BinaryValue bucketName = namespace != null ? namespace.getBucketName() : null;
        BinaryValue bucketType = namespace != null ? namespace.getBucketType() : null;
        key = AnnotationUtil.getKey(domainObject, key);
        bucketName = AnnotationUtil.getBucketName(domainObject, bucketName);
        bucketType = AnnotationUtil.getBucketType(domainObject, bucketType);
        if (bucketName == null) {
            throw new ConversionException("Bucket name not provided via namespace or domain object");
        }
        VClock vclock = AnnotationUtil.getVClock(domainObject);
        String contentType = AnnotationUtil.getContentType(domainObject, "application/octet-stream");
        RiakObject riakObject = new RiakObject();
        AnnotationUtil.getUsermetaData(riakObject.getUserMeta(), domainObject);
        AnnotationUtil.getIndexes(riakObject.getIndexes(), domainObject);
        AnnotationUtil.getLinks(riakObject.getLinks(), domainObject);
        ContentAndType cAndT = this.fromDomain(domainObject);
        contentType = cAndT.contentType != null ? cAndT.contentType : contentType;
        riakObject.setContentType(contentType).setValue(cAndT.content).setVClock(vclock);
        Namespace ns = bucketType == null ? new Namespace(bucketName) : new Namespace(bucketType, bucketName);
        OrmExtracted extracted = new OrmExtracted(riakObject, ns, key);
        return extracted;
    }

    public abstract ContentAndType fromDomain(T var1) throws ConversionException;

    protected class ContentAndType {
        private final BinaryValue content;
        private final String contentType;

        public ContentAndType(BinaryValue content, String contentType) {
            this.content = content;
            this.contentType = contentType;
        }
    }

    public static class OrmExtracted {
        private final RiakObject riakObject;
        private final Namespace namespace;
        private final BinaryValue key;

        public OrmExtracted(RiakObject riakObject, Namespace namespace, BinaryValue key) {
            this.riakObject = riakObject;
            this.namespace = namespace;
            this.key = key;
        }

        public RiakObject getRiakObject() {
            return this.riakObject;
        }

        public Namespace getNamespace() {
            return this.namespace;
        }

        public boolean hasKey() {
            return this.key != null;
        }

        public BinaryValue getKey() {
            return this.key;
        }
    }
}

