/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.convert;

import com.basho.riak.client.api.convert.Converter;
import com.basho.riak.client.api.convert.JSONConverter;
import com.basho.riak.client.api.convert.PassThroughConverter;
import com.basho.riak.client.api.convert.StringConverter;
import com.basho.riak.client.core.query.RiakObject;
import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum ConverterFactory {
    INSTANCE;

    private final Map<Type, Converter<?>> converterInstances = new ConcurrentHashMap<Type, Converter<?>>(){
        {
            this.put(new TypeReference<RiakObject>(){}.getType(), new PassThroughConverter());
            this.put(RiakObject.class, new PassThroughConverter());
            this.put(new TypeReference<String>(){}.getType(), new StringConverter());
            this.put(String.class, new StringConverter());
        }
    };

    public static ConverterFactory getInstance() {
        return INSTANCE;
    }

    public <T> Converter<T> getConverter(Type type) {
        return this.getConverter(type, null);
    }

    public <T> Converter<T> getConverter(TypeReference<T> typeReference) {
        return this.getConverter(null, typeReference);
    }

    private <T> Converter<T> getConverter(Type type, TypeReference<T> typeReference) {
        Converter<?> converter = this.converterInstances.get(type = type != null ? type : typeReference.getType());
        if (converter == null) {
            converter = typeReference != null ? new JSONConverter(typeReference) : new JSONConverter(type);
        }
        return converter;
    }

    public <T> void registerConverterForClass(Class<T> clazz, Converter<T> converter) {
        this.converterInstances.put(clazz, converter);
    }

    public <T> void registerConverterForClass(TypeReference<T> typeReference, Converter<T> converter) {
        Type t = typeReference.getType();
        this.converterInstances.put(t, converter);
    }

    public <T> void unregisterConverterForClass(Class<T> clazz) {
        this.converterInstances.remove(clazz);
    }

    public <T> void unregisterConverterForClass(TypeReference<T> typeReference) {
        Type t = typeReference.getType();
        this.converterInstances.remove(t);
    }
}

