/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core;

import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.NodeManager;
import com.basho.riak.client.core.NodeStateListener;
import com.basho.riak.client.core.RiakNode;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNodeManager
implements NodeManager,
NodeStateListener {
    private final ArrayList<RiakNode> healthy = new ArrayList();
    private final ArrayList<RiakNode> unhealthy = new ArrayList();
    private final AtomicInteger index = new AtomicInteger();
    private final Logger logger = LoggerFactory.getLogger(DefaultNodeManager.class);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(List<RiakNode> nodes) {
        try {
            this.lock.writeLock().lock();
            this.healthy.addAll(nodes);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeOnNode(FutureOperation operation, RiakNode previousNode) {
        try {
            this.lock.readLock().lock();
            boolean executed = false;
            if (this.healthy.size() > 1) {
                int startIndex;
                int currentIndex = startIndex = this.index.getAndIncrement();
                do {
                    if (!this.healthy.get(Math.abs(currentIndex % this.healthy.size())).execute(operation)) continue;
                    executed = true;
                    break;
                } while (Math.abs(++currentIndex % this.healthy.size()) != Math.abs(startIndex % this.healthy.size()));
            } else if (this.healthy.size() == 1) {
                executed = this.healthy.get(0).execute(operation);
            }
            boolean bl = executed;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeStateChanged(RiakNode node, RiakNode.State state) {
        switch (state) {
            case RUNNING: {
                try {
                    this.lock.writeLock().lock();
                    if (!this.unhealthy.remove(node)) break;
                    this.healthy.add(node);
                    this.logger.info("NodeManager moved node to healthy list; {}:{}", (Object)node.getRemoteAddress(), (Object)node.getPort());
                    break;
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            case HEALTH_CHECKING: {
                try {
                    this.lock.writeLock().lock();
                    if (!this.healthy.remove(node)) break;
                    this.unhealthy.add(node);
                    this.logger.info("NodeManager moved node to unhealthy list; {}:{}", (Object)node.getRemoteAddress(), (Object)node.getPort());
                    break;
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            case SHUTTING_DOWN: 
            case SHUTDOWN: {
                boolean removed = false;
                try {
                    this.lock.writeLock().lock();
                    removed = this.healthy.remove(node);
                    if (!removed) {
                        this.unhealthy.remove(node);
                    }
                }
                finally {
                    this.lock.writeLock().unlock();
                }
                if (!removed) break;
                this.logger.info("NodeManager removed node due to it shutting down; {}:{}", (Object)node.getRemoteAddress(), (Object)node.getPort());
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNode(RiakNode newNode) {
        try {
            this.lock.writeLock().lock();
            this.healthy.add(newNode);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeNode(RiakNode node) {
        boolean removed;
        try {
            this.lock.writeLock().lock();
            removed = this.healthy.remove(node);
            if (!removed) {
                removed = this.unhealthy.remove(node);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (removed) {
            node.removeStateListener(this);
            node.shutdown();
            this.logger.info("NodeManager removed and shutdown node; {}:{}", (Object)node.getRemoteAddress(), (Object)node.getPort());
        }
        return removed;
    }
}

