/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core;

import com.basho.riak.client.core.netty.RiakResponseException;
import com.basho.riak.protobuf.RiakPB;
import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpInputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RiakMessage {
    private static final Logger logger = LoggerFactory.getLogger(RiakMessage.class);
    private final byte code;
    private final byte[] data;
    private final RiakResponseException riakError;
    private static final String ERROR_RESP = "rpberrorresp";

    public RiakMessage(byte code, byte[] data) {
        this(code, data, true);
    }

    public RiakMessage(byte code, byte[] data, boolean doErrorCheck) {
        this.code = code;
        this.data = data;
        if (doErrorCheck) {
            switch (this.code) {
                case 0: {
                    this.riakError = RiakMessage.getRiakErrorFromPbuf(this.data);
                    break;
                }
                case 104: {
                    OtpInputStream ttbInputStream = new OtpInputStream(data);
                    this.riakError = this.getRiakErrorFromTtb(ttbInputStream);
                    break;
                }
                default: {
                    this.riakError = null;
                    break;
                }
            }
        } else {
            this.riakError = null;
        }
    }

    private static RiakResponseException getRiakErrorFromPbuf(byte[] data) {
        try {
            RiakPB.RpbErrorResp err = RiakPB.RpbErrorResp.parseFrom(data);
            return new RiakResponseException(err.getErrcode(), err.getErrmsg().toStringUtf8());
        }
        catch (InvalidProtocolBufferException ex) {
            logger.error("exception", (Throwable)ex);
            return new RiakResponseException(0, "Could not parse protocol buffers error");
        }
    }

    public byte getCode() {
        return this.code;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isRiakError() {
        return this.riakError != null;
    }

    public RiakResponseException getRiakError() {
        return this.riakError;
    }

    private RiakResponseException getRiakErrorFromTtb(OtpInputStream ttbInputStream) {
        int ttbMsgArity;
        String decodeErrorMsg = "Error decoding Riak TTB Response, unexpected format.";
        try {
            int firstByte = ttbInputStream.read1skip_version();
            if (firstByte != 104 && firstByte != 105) {
                return null;
            }
            ttbInputStream.reset();
            ttbMsgArity = ttbInputStream.read_tuple_head();
        }
        catch (OtpErlangDecodeException ex) {
            logger.error("Error decoding Riak TTB Response, unexpected format. Was expecting a tuple head.", (Throwable)ex);
            throw new IllegalArgumentException("Error decoding Riak TTB Response, unexpected format.", ex);
        }
        if (ttbMsgArity == 3) {
            String atom;
            try {
                atom = ttbInputStream.read_atom();
            }
            catch (OtpErlangDecodeException ex) {
                logger.error("Error decoding Riak TTB Response, unexpected format. Was expecting an atom.", (Throwable)ex);
                throw new IllegalArgumentException("Error decoding Riak TTB Response, unexpected format.", ex);
            }
            if (ERROR_RESP.equals(atom)) {
                try {
                    String errMsg = new String(ttbInputStream.read_binary(), StandardCharsets.UTF_8);
                    int errCode = ttbInputStream.read_int();
                    return new RiakResponseException(errCode, errMsg);
                }
                catch (OtpErlangDecodeException ex) {
                    logger.error("Error decoding Riak TTB Response, unexpected format.", (Throwable)ex);
                    throw new IllegalArgumentException("Error decoding Riak TTB Response, unexpected format.", ex);
                }
            }
        }
        return null;
    }
}

