/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.codec;

import com.basho.riak.client.core.codec.InvalidTermToBinaryException;
import com.basho.riak.client.core.query.timeseries.Cell;
import com.basho.riak.client.core.query.timeseries.QueryResult;
import com.basho.riak.client.core.query.timeseries.Row;
import com.basho.riak.client.core.util.CharsetUtils;
import com.basho.riak.protobuf.RiakTsPB;
import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangBinary;
import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangDouble;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangLong;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import com.google.protobuf.ByteString;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermToBinaryCodec {
    private static final String TS_GET_REQ = "tsgetreq";
    private static final String TS_GET_RESP = "tsgetresp";
    private static final String TS_QUERY_REQ = "tsqueryreq";
    private static final String TS_QUERY_RESP = "tsqueryresp";
    private static final String TS_INTERPOLATION = "tsinterpolation";
    private static final String TS_PUT_REQ = "tsputreq";
    private static final String UNDEFINED = "undefined";
    private static final Logger logger = LoggerFactory.getLogger(TermToBinaryCodec.class);

    public static OtpOutputStream encodeTsGetRequest(String tableName, Collection<Cell> keyValues, int timeout) {
        OtpOutputStream os = new OtpOutputStream();
        os.write(131);
        os.write_tuple_head(4);
        os.write_atom(TS_GET_REQ);
        os.write_binary(tableName.getBytes(StandardCharsets.UTF_8));
        os.write_list_head(keyValues.size());
        for (Cell cell : keyValues) {
            TermToBinaryCodec.writeTsCellToStream(os, cell);
        }
        os.write_nil();
        os.write_long((long)timeout);
        return os;
    }

    public static QueryResult decodeTsResultResponse(byte[] response) throws OtpErlangDecodeException, InvalidTermToBinaryException {
        return TermToBinaryCodec.decodeTsResponse(response);
    }

    public static OtpOutputStream encodeTsQueryRequest(String queryText) {
        OtpOutputStream os = new OtpOutputStream();
        os.write(131);
        os.write_tuple_head(4);
        os.write_atom(TS_QUERY_REQ);
        os.write_tuple_head(3);
        os.write_atom(TS_INTERPOLATION);
        os.write_binary(queryText.getBytes(StandardCharsets.UTF_8));
        os.write_nil();
        os.write_boolean(false);
        os.write_atom(UNDEFINED);
        return os;
    }

    public static OtpOutputStream encodeTsPutRequest(String tableName, Collection<Row> rows) {
        OtpOutputStream os = new OtpOutputStream();
        os.write(131);
        os.write_tuple_head(4);
        os.write_atom(TS_PUT_REQ);
        os.write_binary(tableName.getBytes(StandardCharsets.UTF_8));
        os.write_nil();
        os.write_list_head(rows.size());
        for (Row row : rows) {
            os.write_tuple_head(row.getCellsCount());
            for (Cell cell : row) {
                if (cell == null) {
                    os.write_nil();
                    continue;
                }
                TermToBinaryCodec.writeTsCellToStream(os, cell);
            }
        }
        os.write_nil();
        return os;
    }

    private static void writeTsCellToStream(OtpOutputStream stream, Cell cell) {
        if (cell.hasVarcharValue()) {
            stream.write_binary(cell.getVarcharAsUTF8String().getBytes(CharsetUtils.UTF_8));
        } else if (cell.hasLong()) {
            stream.write_long(cell.getLong());
        } else if (cell.hasTimestamp()) {
            stream.write_long(cell.getTimestamp());
        } else if (cell.hasBoolean()) {
            stream.write_boolean(cell.getBoolean());
        } else if (cell.hasDouble()) {
            stream.write_double(cell.getDouble());
        } else {
            logger.error("Unknown TS cell type encountered.");
            throw new IllegalArgumentException("Unknown TS cell type encountered.");
        }
    }

    private static QueryResult decodeTsResponse(byte[] response) throws OtpErlangDecodeException, InvalidTermToBinaryException {
        Object result = null;
        OtpInputStream is = new OtpInputStream(response);
        int firstByte = is.read1skip_version();
        is.reset();
        if (firstByte != 104 && firstByte != 105) {
            return TermToBinaryCodec.parseAtomResult(is);
        }
        return TermToBinaryCodec.parseTupleResult(is);
    }

    private static QueryResult parseAtomResult(OtpInputStream is) throws OtpErlangDecodeException, InvalidTermToBinaryException {
        String responseAtom = is.read_atom();
        if (Objects.equals(responseAtom, TS_QUERY_RESP)) {
            return QueryResult.EMPTY;
        }
        throw new InvalidTermToBinaryException("Invalid Response atom encountered: " + responseAtom + ". Was expecting tsqueryresp");
    }

    private static QueryResult parseTupleResult(OtpInputStream is) throws OtpErlangDecodeException, InvalidTermToBinaryException {
        QueryResult result;
        String respAtom;
        int msgArity = is.read_tuple_head();
        switch (respAtom = is.read_atom()) {
            case "tsgetresp": 
            case "tsqueryresp": {
                assert (msgArity == 2);
                int dataArity = is.read_tuple_head();
                assert (dataArity == 3);
                ArrayList<RiakTsPB.TsColumnDescription> columnDescriptions = TermToBinaryCodec.parseColumnDescriptions(is);
                ArrayList<RiakTsPB.TsRow> rows = TermToBinaryCodec.parseRows(is, columnDescriptions);
                result = new QueryResult(columnDescriptions, rows);
                break;
            }
            default: {
                String errorMsg = "Unsupported response message received: " + respAtom;
                logger.error(errorMsg);
                throw new IllegalArgumentException(errorMsg);
            }
        }
        return result;
    }

    private static ArrayList<RiakTsPB.TsColumnDescription> parseColumnDescriptions(OtpInputStream is) throws OtpErlangDecodeException {
        int colNameCount = is.read_list_head();
        String[] columnNames = new String[colNameCount];
        for (int colNameIdx = 0; colNameIdx < colNameCount; ++colNameIdx) {
            String colName;
            columnNames[colNameIdx] = colName = new String(is.read_binary(), StandardCharsets.UTF_8);
        }
        if (colNameCount > 0) {
            is.read_nil();
        }
        int colTypeCount = is.read_list_head();
        assert (colNameCount == colTypeCount);
        String[] columnTypes = new String[colTypeCount];
        for (int colTypeIdx = 0; colTypeIdx < colTypeCount; ++colTypeIdx) {
            String colType;
            columnTypes[colTypeIdx] = colType = is.read_atom();
        }
        if (colTypeCount > 0) {
            is.read_nil();
        }
        ArrayList<RiakTsPB.TsColumnDescription> columnDescriptions = new ArrayList<RiakTsPB.TsColumnDescription>(colNameCount);
        for (int colDescIdx = 0; colDescIdx < colNameCount; ++colDescIdx) {
            RiakTsPB.TsColumnDescription.Builder descBuilder = RiakTsPB.TsColumnDescription.newBuilder();
            descBuilder.setName(ByteString.copyFromUtf8((String)columnNames[colDescIdx]));
            descBuilder.setType(RiakTsPB.TsColumnType.valueOf(columnTypes[colDescIdx].toUpperCase(Locale.US)));
            columnDescriptions.add(descBuilder.build());
        }
        return columnDescriptions;
    }

    private static ArrayList<RiakTsPB.TsRow> parseRows(OtpInputStream is, List<RiakTsPB.TsColumnDescription> columnDescriptions) throws OtpErlangDecodeException, InvalidTermToBinaryException {
        int rowCount = is.read_list_head();
        ArrayList<RiakTsPB.TsRow> rows = new ArrayList<RiakTsPB.TsRow>(rowCount);
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            rows.add(TermToBinaryCodec.parseRow(is, columnDescriptions));
        }
        return rows;
    }

    private static RiakTsPB.TsRow parseRow(OtpInputStream is, List<RiakTsPB.TsColumnDescription> columnDescriptions) throws OtpErlangDecodeException, InvalidTermToBinaryException {
        int rowDataCount = is.read_tuple_head();
        assert (columnDescriptions.size() == rowDataCount);
        Cell[] cells = new Cell[rowDataCount];
        for (int j = 0; j < rowDataCount; ++j) {
            OtpErlangObject cell = is.read_any();
            cells[j] = TermToBinaryCodec.parseCell(columnDescriptions, j, cell);
        }
        return new Row(cells).getPbRow();
    }

    private static Cell parseCell(List<RiakTsPB.TsColumnDescription> columnDescriptions, int j, OtpErlangObject cell) throws InvalidTermToBinaryException {
        if (cell instanceof OtpErlangBinary) {
            OtpErlangBinary v = (OtpErlangBinary)cell;
            String s = new String(v.binaryValue(), StandardCharsets.UTF_8);
            return new Cell(s);
        }
        if (cell instanceof OtpErlangLong) {
            OtpErlangLong v = (OtpErlangLong)cell;
            if (columnDescriptions.get(j).getType() == RiakTsPB.TsColumnType.TIMESTAMP) {
                return Cell.newTimestamp(v.longValue());
            }
            return new Cell(v.longValue());
        }
        if (cell instanceof OtpErlangDouble) {
            OtpErlangDouble v = (OtpErlangDouble)cell;
            return new Cell(v.doubleValue());
        }
        if (cell instanceof OtpErlangAtom) {
            OtpErlangAtom v = (OtpErlangAtom)cell;
            return new Cell(v.booleanValue());
        }
        if (cell instanceof OtpErlangList) {
            OtpErlangList l = (OtpErlangList)cell;
            assert (l.arity() == 0);
            return null;
        }
        throw new InvalidTermToBinaryException("Unknown cell type encountered: " + cell.toString() + ", unable to" + " continue parsing.");
    }
}

