/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.converters;

import com.basho.riak.client.core.query.crdt.types.RiakCounter;
import com.basho.riak.client.core.query.crdt.types.RiakDatatype;
import com.basho.riak.client.core.query.crdt.types.RiakFlag;
import com.basho.riak.client.core.query.crdt.types.RiakMap;
import com.basho.riak.client.core.query.crdt.types.RiakRegister;
import com.basho.riak.client.core.query.crdt.types.RiakSet;
import com.basho.riak.client.core.util.BinaryValue;
import com.basho.riak.protobuf.RiakDtPB;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;

public class CrdtResponseConverter {
    private RiakDatatype parseSet(List<ByteString> setValues) {
        ArrayList<BinaryValue> entries = new ArrayList<BinaryValue>(setValues.size());
        for (ByteString bstring : setValues) {
            entries.add(BinaryValue.unsafeCreate(bstring.toByteArray()));
        }
        return new RiakSet(entries);
    }

    private RiakDatatype parseMap(List<RiakDtPB.MapEntry> mapEntries) {
        ArrayList<RiakMap.MapEntry> entries = new ArrayList<RiakMap.MapEntry>(mapEntries.size());
        for (RiakDtPB.MapEntry entry : mapEntries) {
            RiakDatatype element;
            RiakDtPB.MapField field = entry.getField();
            switch (field.getType()) {
                case COUNTER: {
                    element = new RiakCounter(entry.getCounterValue());
                    break;
                }
                case FLAG: {
                    element = new RiakFlag(entry.getFlagValue());
                    break;
                }
                case MAP: {
                    element = this.parseMap(entry.getMapValueList());
                    break;
                }
                case REGISTER: {
                    element = new RiakRegister(BinaryValue.unsafeCreate(entry.getRegisterValue().toByteArray()));
                    break;
                }
                case SET: {
                    element = this.parseSet(entry.getSetValueList());
                    break;
                }
                default: {
                    throw new IllegalStateException("Expecting a datatype in map entry but none found");
                }
            }
            BinaryValue key = BinaryValue.unsafeCreate(entry.getField().getName().toByteArray());
            entries.add(new RiakMap.MapEntry(key, element));
        }
        return new RiakMap(entries);
    }

    public RiakDatatype convert(RiakDtPB.DtUpdateResp response) {
        RiakDatatype element = null;
        if (response.hasCounterValue()) {
            element = new RiakCounter(response.getCounterValue());
        } else if (response.getSetValueCount() > 0) {
            element = this.parseSet(response.getSetValueList());
        } else if (response.getMapValueCount() > 0) {
            element = this.parseMap(response.getMapValueList());
        }
        return element;
    }

    public RiakDatatype convert(RiakDtPB.DtFetchResp response) {
        RiakDatatype element;
        switch (response.getType()) {
            case COUNTER: {
                element = new RiakCounter(response.getValue().getCounterValue());
                break;
            }
            case MAP: {
                element = this.parseMap(response.getValue().getMapValueList());
                break;
            }
            case SET: {
                element = this.parseSet(response.getValue().getSetValueList());
                break;
            }
            default: {
                throw new IllegalStateException("No known datatype returned");
            }
        }
        return element;
    }
}

