/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.netty;

import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.RiakFutureListener;
import com.basho.riak.client.core.RiakMessage;
import com.basho.riak.client.core.netty.RiakResponseException;
import com.basho.riak.protobuf.RiakPB;
import com.google.protobuf.InvalidProtocolBufferException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HealthCheckDecoder
extends ByteToMessageDecoder {
    private final Logger logger = LoggerFactory.getLogger(HealthCheckDecoder.class);
    private final HealthCheckFuture future = new HealthCheckFuture();

    protected abstract FutureOperation<?, ?, ?> buildOperation();

    protected void decode(ChannelHandlerContext chc, ByteBuf in, List<Object> list) throws Exception {
        if (in.readableBytes() >= 4) {
            in.markReaderIndex();
            int length = in.readInt();
            if (in.readableBytes() < length) {
                in.resetReaderIndex();
            } else {
                byte code = in.readByte();
                byte[] protobuf = new byte[length - 1];
                in.readBytes(protobuf);
                chc.channel().pipeline().remove((ChannelHandler)this);
                if (code == 0) {
                    this.logger.debug("Received MSG_ErrorResp reply to healthcheck");
                    this.future.setException(this.riakErrorToException(protobuf));
                } else {
                    this.logger.debug("Healthcheck op successful; returned code {}", (Object)code);
                    this.future.setMessage(new RiakMessage(code, protobuf));
                }
            }
        }
    }

    private void init(ChannelHandlerContext ctx) throws InterruptedException {
        ChannelFuture writeAndFlush = ctx.channel().writeAndFlush(this.buildOperation().channelMessage());
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.logger.debug("HealthCheckDecoder Handler Added");
        if (ctx.channel().isActive()) {
            this.init(ctx);
        } else {
            this.future.setException(new IOException("HealthCheckDecoder added to inactive channel"));
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.logger.debug("HealthCheckDecoder Channel Active");
        this.init(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.logger.debug("Healthcheck channel went inactive");
        this.future.setException(new IOException("Channel closed while performing health check op."));
        ctx.fireChannelInactive();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.future.setException(new IOException("Exception in channel while performing health check op.", cause));
    }

    public RiakFuture<RiakMessage, Void> getFuture() {
        return this.future;
    }

    private RiakResponseException riakErrorToException(byte[] protobuf) {
        try {
            RiakPB.RpbErrorResp error = RiakPB.RpbErrorResp.parseFrom(protobuf);
            return new RiakResponseException(error.getErrcode(), error.getErrmsg().toStringUtf8());
        }
        catch (InvalidProtocolBufferException ex) {
            return null;
        }
    }

    public static class HealthCheckFuture
    implements RiakFuture<RiakMessage, Void> {
        private final CountDownLatch latch = new CountDownLatch(1);
        private volatile Throwable exception;
        private volatile RiakMessage message;

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.latch.getCount() != 1L;
        }

        @Override
        public RiakMessage get() throws InterruptedException, ExecutionException {
            this.latch.await();
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.message;
        }

        @Override
        public RiakMessage get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            boolean succeed = this.latch.await(timeout, unit);
            if (!succeed) {
                throw new TimeoutException();
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.message;
        }

        public void setException(Throwable e) {
            this.exception = e;
            this.latch.countDown();
        }

        public void setMessage(RiakMessage m) {
            this.message = m;
            this.latch.countDown();
        }

        @Override
        public void await() throws InterruptedException {
            this.latch.await();
        }

        @Override
        public void await(long timeout, TimeUnit unit) throws InterruptedException {
            this.latch.await(timeout, unit);
        }

        @Override
        public RiakMessage getNow() {
            return this.message;
        }

        @Override
        public boolean isSuccess() {
            return this.isDone() && this.exception == null;
        }

        @Override
        public Throwable cause() {
            return this.exception;
        }

        @Override
        public Void getQueryInfo() {
            return null;
        }

        @Override
        public void addListener(RiakFutureListener<RiakMessage, Void> listener) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void removeListener(RiakFutureListener<RiakMessage, Void> listener) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

