/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.netty;

import com.basho.riak.client.core.RiakMessage;
import com.basho.riak.client.core.RiakResponseListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;

public class RiakResponseHandler
extends ChannelInboundHandlerAdapter {
    private RiakResponseListener listener;

    public RiakResponseHandler(RiakResponseListener listener) {
        this.listener = listener;
    }

    public void channelRead(ChannelHandlerContext chc, Object message) throws Exception {
        RiakMessage riakMessage = (RiakMessage)message;
        if (riakMessage.isRiakError()) {
            this.listener.onRiakErrorResponse(chc.channel(), riakMessage.getRiakError());
        } else {
            this.listener.onSuccess(chc.channel(), riakMessage);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.listener.onException(ctx.channel(), cause);
        ctx.close();
    }
}

