/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations;

import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.RiakMessage;
import com.basho.riak.client.core.converters.CrdtResponseConverter;
import com.basho.riak.client.core.operations.Operations;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.crdt.types.RiakDatatype;
import com.basho.riak.client.core.util.BinaryValue;
import com.basho.riak.protobuf.RiakDtPB;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;

public class DtFetchOperation
extends FutureOperation<Response, RiakDtPB.DtFetchResp, Location> {
    private final Location location;
    private final RiakDtPB.DtFetchReq.Builder reqBuilder;

    private DtFetchOperation(Builder builder) {
        this.reqBuilder = builder.reqBuilder;
        this.location = builder.location;
    }

    @Override
    protected Response convert(List<RiakDtPB.DtFetchResp> rawResponse) {
        if (rawResponse.size() != 1) {
            throw new IllegalStateException("Expecting exactly one response, instead received " + rawResponse.size());
        }
        RiakDtPB.DtFetchResp response = rawResponse.iterator().next();
        CrdtResponseConverter converter = new CrdtResponseConverter();
        RiakDatatype element = converter.convert(response);
        Response.Builder responseBuilder = (Response.Builder)new Response.Builder().withCrdtElement(element);
        if (response.hasContext()) {
            BinaryValue ctxWrapper = BinaryValue.create(response.getContext().toByteArray());
            responseBuilder.withContext(ctxWrapper);
        }
        return responseBuilder.build();
    }

    @Override
    protected RiakMessage createChannelMessage() {
        return new RiakMessage(80, this.reqBuilder.build().toByteArray());
    }

    @Override
    protected RiakDtPB.DtFetchResp decode(RiakMessage rawMessage) {
        Operations.checkPBMessageType(rawMessage, (byte)81);
        try {
            return RiakDtPB.DtFetchResp.parseFrom(rawMessage.getData());
        }
        catch (InvalidProtocolBufferException ex) {
            throw new IllegalArgumentException("Invalid message received", ex);
        }
    }

    @Override
    public Location getQueryInfo() {
        return this.location;
    }

    public static class Response {
        private final BinaryValue context;
        private final RiakDatatype crdtElement;

        protected Response(Init<?> builder) {
            this.context = ((Init)builder).context;
            this.crdtElement = ((Init)builder).crdtElement;
        }

        public boolean hasContext() {
            return this.context != null;
        }

        public BinaryValue getContext() {
            return this.context;
        }

        public boolean hasCrdtElement() {
            return this.crdtElement != null;
        }

        public RiakDatatype getCrdtElement() {
            return this.crdtElement;
        }

        private static class Builder
        extends Init<Builder> {
            private Builder() {
            }

            @Override
            protected Builder self() {
                return this;
            }

            @Override
            protected Response build() {
                return new Response(this);
            }
        }

        protected static abstract class Init<T extends Init<T>> {
            private BinaryValue context;
            private RiakDatatype crdtElement;

            protected Init() {
            }

            protected abstract T self();

            protected abstract Response build();

            T withContext(BinaryValue context) {
                if (context != null) {
                    if (context.length() == 0) {
                        throw new IllegalArgumentException("Context cannot be null or zero length");
                    }
                    this.context = context;
                }
                return this.self();
            }

            T withCrdtElement(RiakDatatype crdtElement) {
                this.crdtElement = crdtElement;
                return this.self();
            }
        }
    }

    public static class Builder {
        private final RiakDtPB.DtFetchReq.Builder reqBuilder = RiakDtPB.DtFetchReq.newBuilder();
        private final Location location;

        public Builder(Location location) {
            if (location == null) {
                throw new IllegalArgumentException("Location can not be null");
            }
            this.reqBuilder.setBucket(ByteString.copyFrom((byte[])location.getNamespace().getBucketName().unsafeGetValue()));
            this.reqBuilder.setKey(ByteString.copyFrom((byte[])location.getKey().unsafeGetValue()));
            this.reqBuilder.setType(ByteString.copyFrom((byte[])location.getNamespace().getBucketType().unsafeGetValue()));
            this.location = location;
        }

        public Builder includeContext(boolean context) {
            this.reqBuilder.setIncludeContext(context);
            return this;
        }

        public Builder withR(int r) {
            this.reqBuilder.setR(r);
            return this;
        }

        public Builder withPr(int pr) {
            this.reqBuilder.setPr(pr);
            return this;
        }

        public Builder withNotFoundOK(boolean notFoundOK) {
            this.reqBuilder.setNotfoundOk(notFoundOK);
            return this;
        }

        public Builder withBasicQuorum(boolean useBasicQuorum) {
            this.reqBuilder.setBasicQuorum(useBasicQuorum);
            return this;
        }

        public Builder withTimeout(int timeout) {
            this.reqBuilder.setTimeout(timeout);
            return this;
        }

        public Builder withNVal(int nval) {
            this.reqBuilder.setNVal(nval);
            return this;
        }

        public Builder withSloppyQuorum(boolean sloppyQuorum) {
            this.reqBuilder.setSloppyQuorum(sloppyQuorum);
            return this;
        }

        public DtFetchOperation build() {
            return new DtFetchOperation(this);
        }
    }
}

