/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations;

import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.RiakMessage;
import com.basho.riak.client.core.operations.Operations;
import com.basho.riak.client.core.util.BinaryValue;
import com.basho.riak.protobuf.RiakKvPB;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;

public class ListBucketsOperation
extends FutureOperation<Response, RiakKvPB.RpbListBucketsResp, BinaryValue> {
    private final RiakKvPB.RpbListBucketsReq.Builder reqBuilder;
    private final BinaryValue bucketType;

    private ListBucketsOperation(Builder builder) {
        this.reqBuilder = builder.reqBuilder;
        this.bucketType = builder.bucketType;
    }

    @Override
    protected boolean done(RiakKvPB.RpbListBucketsResp message) {
        return message.getDone();
    }

    @Override
    protected Response convert(List<RiakKvPB.RpbListBucketsResp> rawResponse) {
        ArrayList<BinaryValue> buckets = new ArrayList<BinaryValue>(rawResponse.size());
        for (RiakKvPB.RpbListBucketsResp resp : rawResponse) {
            for (ByteString bucket : resp.getBucketsList()) {
                buckets.add(BinaryValue.unsafeCreate(bucket.toByteArray()));
            }
        }
        return new Response(this.bucketType, buckets);
    }

    @Override
    protected RiakMessage createChannelMessage() {
        return new RiakMessage(15, this.reqBuilder.build().toByteArray());
    }

    @Override
    protected RiakKvPB.RpbListBucketsResp decode(RiakMessage rawMessage) {
        try {
            Operations.checkPBMessageType(rawMessage, (byte)16);
            return RiakKvPB.RpbListBucketsResp.parseFrom(rawMessage.getData());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Invalid message received", e);
        }
    }

    @Override
    public BinaryValue getQueryInfo() {
        return this.bucketType;
    }

    public static class Response {
        private final BinaryValue bucketType;
        private final List<BinaryValue> buckets;

        Response(BinaryValue bucketType, List<BinaryValue> buckets) {
            this.bucketType = bucketType;
            this.buckets = buckets;
        }

        public BinaryValue getBucketType() {
            return this.bucketType;
        }

        public List<BinaryValue> getBuckets() {
            return this.buckets;
        }
    }

    public static class Builder {
        private final RiakKvPB.RpbListBucketsReq.Builder reqBuilder = RiakKvPB.RpbListBucketsReq.newBuilder().setStream(true);
        private BinaryValue bucketType = BinaryValue.create("default");

        public Builder withTimeout(int timeout) {
            if (timeout <= 0) {
                throw new IllegalArgumentException("Timeout can not be zero or less.");
            }
            this.reqBuilder.setTimeout(timeout);
            return this;
        }

        public Builder withBucketType(BinaryValue bucketType) {
            if (null == bucketType || bucketType.length() == 0) {
                throw new IllegalArgumentException("Bucket type can not be null or zero length");
            }
            this.reqBuilder.setType(ByteString.copyFrom((byte[])bucketType.unsafeGetValue()));
            this.bucketType = bucketType;
            return this;
        }

        public ListBucketsOperation build() {
            return new ListBucketsOperation(this);
        }
    }
}

