/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations;

import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.RiakMessage;
import com.basho.riak.client.core.operations.Operations;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.util.BinaryValue;
import com.basho.riak.protobuf.RiakKvPB;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListKeysOperation
extends FutureOperation<Response, RiakKvPB.RpbListKeysResp, Namespace> {
    private final Logger logger = LoggerFactory.getLogger((String)"ListKeysOperation");
    private final Namespace namespace;
    private final RiakKvPB.RpbListKeysReq.Builder reqBuilder;

    private ListKeysOperation(Builder builder) {
        this.reqBuilder = builder.reqBuilder;
        this.namespace = builder.namespace;
    }

    @Override
    protected Response convert(List<RiakKvPB.RpbListKeysResp> rawResponse) {
        Response.Builder builder = new Response.Builder();
        for (RiakKvPB.RpbListKeysResp resp : rawResponse) {
            for (ByteString bucket : resp.getKeysList()) {
                builder.addKey(BinaryValue.unsafeCreate(bucket.toByteArray()));
            }
        }
        return builder.build();
    }

    @Override
    protected RiakMessage createChannelMessage() {
        return new RiakMessage(17, this.reqBuilder.build().toByteArray());
    }

    @Override
    protected RiakKvPB.RpbListKeysResp decode(RiakMessage rawMessage) {
        try {
            Operations.checkPBMessageType(rawMessage, (byte)18);
            return RiakKvPB.RpbListKeysResp.parseFrom(rawMessage.getData());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Invalid message received", e);
        }
    }

    @Override
    protected boolean done(RiakKvPB.RpbListKeysResp message) {
        return message.getDone();
    }

    @Override
    public Namespace getQueryInfo() {
        return this.namespace;
    }

    public static class Response {
        private final List<BinaryValue> keys;

        private Response(Builder builder) {
            this.keys = builder.keys;
        }

        public List<BinaryValue> getKeys() {
            return this.keys;
        }

        static class Builder {
            private List<BinaryValue> keys = new ArrayList<BinaryValue>();

            Builder() {
            }

            Builder addKeys(List<BinaryValue> keys) {
                this.keys.addAll(keys);
                return this;
            }

            Builder addKey(BinaryValue key) {
                this.keys.add(key);
                return this;
            }

            Response build() {
                return new Response(this);
            }
        }
    }

    public static class Builder {
        private final RiakKvPB.RpbListKeysReq.Builder reqBuilder = RiakKvPB.RpbListKeysReq.newBuilder();
        private final Namespace namespace;

        public Builder(Namespace namespace) {
            if (namespace == null) {
                throw new IllegalArgumentException("Namespace cannot be null");
            }
            this.reqBuilder.setBucket(ByteString.copyFrom((byte[])namespace.getBucketName().unsafeGetValue()));
            this.reqBuilder.setType(ByteString.copyFrom((byte[])namespace.getBucketType().unsafeGetValue()));
            this.namespace = namespace;
        }

        public Builder withTimeout(int timeout) {
            if (timeout <= 0) {
                throw new IllegalArgumentException("Timeout can not be zero or less");
            }
            this.reqBuilder.setTimeout(timeout);
            return this;
        }

        public ListKeysOperation build() {
            return new ListKeysOperation(this);
        }
    }
}

