/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations;

import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.RiakMessage;
import com.basho.riak.client.core.operations.Operations;
import com.basho.riak.client.core.util.BinaryValue;
import com.basho.riak.protobuf.RiakPB;
import com.basho.riak.protobuf.RiakSearchPB;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SearchOperation
extends FutureOperation<Response, RiakSearchPB.RpbSearchQueryResp, BinaryValue> {
    private final String queryString;
    private final BinaryValue indexName;
    private final RiakSearchPB.RpbSearchQueryReq.Builder reqBuilder;

    private SearchOperation(Builder builder) {
        this.reqBuilder = builder.reqBuilder;
        this.queryString = builder.queryString;
        this.indexName = builder.indexName;
    }

    @Override
    protected Response convert(List<RiakSearchPB.RpbSearchQueryResp> rawResponse) {
        RiakSearchPB.RpbSearchQueryResp resp = rawResponse.get(0);
        LinkedList<Map<String, List<String>>> docList = new LinkedList<Map<String, List<String>>>();
        for (RiakSearchPB.RpbSearchDoc pbDoc : resp.getDocsList()) {
            HashMap<String, LinkedList<String>> map = new HashMap<String, LinkedList<String>>();
            for (RiakPB.RpbPair pair : pbDoc.getFieldsList()) {
                String key = pair.getKey().toStringUtf8();
                LinkedList<String> list = (LinkedList<String>)map.get(key);
                if (null == list) {
                    list = new LinkedList<String>();
                    map.put(key, list);
                }
                list.add(pair.getValue().toStringUtf8());
            }
            docList.add(map);
        }
        return new Response(docList, resp.getMaxScore(), resp.getNumFound());
    }

    @Override
    protected RiakMessage createChannelMessage() {
        RiakSearchPB.RpbSearchQueryReq req = this.reqBuilder.build();
        return new RiakMessage(27, req.toByteArray());
    }

    @Override
    protected RiakSearchPB.RpbSearchQueryResp decode(RiakMessage rawMessage) {
        Operations.checkPBMessageType(rawMessage, (byte)28);
        try {
            return RiakSearchPB.RpbSearchQueryResp.parseFrom(rawMessage.getData());
        }
        catch (InvalidProtocolBufferException ex) {
            throw new IllegalArgumentException("Invalid message received", ex);
        }
    }

    @Override
    public BinaryValue getQueryInfo() {
        return BinaryValue.create(this.indexName.toString() + ": " + this.queryString);
    }

    public static class Response
    implements Iterable {
        private final List<Map<String, List<String>>> results;
        private final float maxScore;
        private final int numResults;

        Response(List<Map<String, List<String>>> results, float maxScore, int numResults) {
            this.results = results;
            this.maxScore = maxScore;
            this.numResults = numResults;
        }

        public Iterator<Map<String, List<String>>> iterator() {
            return this.results.iterator();
        }

        public float getMaxScore() {
            return this.maxScore;
        }

        public int numResults() {
            return this.numResults;
        }

        public List<Map<String, List<String>>> getAllResults() {
            return this.results;
        }
    }

    public static class Builder {
        private final BinaryValue indexName;
        private final String queryString;
        private final RiakSearchPB.RpbSearchQueryReq.Builder reqBuilder = RiakSearchPB.RpbSearchQueryReq.newBuilder();

        public Builder(BinaryValue indexName, String queryString) {
            if (null == indexName || indexName.length() == 0) {
                throw new IllegalArgumentException("Index name cannot be null or zero length");
            }
            if (null == queryString || queryString.length() == 0) {
                throw new IllegalArgumentException("Query string cannot be null or zero length");
            }
            this.indexName = indexName;
            this.queryString = queryString;
            this.reqBuilder.setIndex(ByteString.copyFrom((byte[])indexName.unsafeGetValue()));
            this.reqBuilder.setQ(ByteString.copyFromUtf8((String)queryString));
        }

        public Builder withNumRows(int rows) {
            if (rows < 0) {
                throw new IllegalArgumentException("Rows must be >= 0");
            }
            this.reqBuilder.setRows(rows);
            return this;
        }

        public Builder withStart(int start) {
            if (start < 0) {
                throw new IllegalArgumentException("Start must be >= 0");
            }
            this.reqBuilder.setStart(start);
            return this;
        }

        public Builder withSortField(String fieldName) {
            this.stringCheck(fieldName);
            this.reqBuilder.setSort(ByteString.copyFromUtf8((String)fieldName));
            return this;
        }

        public Builder withFilterQuery(String filterQuery) {
            this.stringCheck(filterQuery);
            this.reqBuilder.setFilter(ByteString.copyFromUtf8((String)filterQuery));
            return this;
        }

        public Builder withDefaultField(String fieldName) {
            this.stringCheck(fieldName);
            this.reqBuilder.setDf(ByteString.copyFromUtf8((String)fieldName));
            return this;
        }

        public Builder withDefaultOperation(String op) {
            this.stringCheck(op);
            this.reqBuilder.setOp(ByteString.copyFromUtf8((String)op));
            return this;
        }

        public Builder withReturnFields(List<String> fields) {
            for (String f : fields) {
                this.stringCheck(f);
                this.reqBuilder.addFl(ByteString.copyFromUtf8((String)f));
            }
            return this;
        }

        public Builder withPresort(String presort) {
            this.stringCheck(presort);
            this.reqBuilder.setPresort(ByteString.copyFromUtf8((String)presort));
            return this;
        }

        private void stringCheck(String arg) {
            if (null == arg || arg.length() == 0) {
                throw new IllegalArgumentException("Argument cannot be null or zero length");
            }
        }

        public SearchOperation build() {
            return new SearchOperation(this);
        }
    }
}

