/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations;

import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.RiakMessage;
import com.basho.riak.client.core.operations.Operations;
import com.basho.riak.client.core.query.search.YokozunaIndex;
import com.basho.riak.protobuf.RiakYokozunaPB;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;

public class YzFetchIndexOperation
extends FutureOperation<Response, RiakYokozunaPB.RpbYokozunaIndexGetResp, String> {
    private final RiakYokozunaPB.RpbYokozunaIndexGetReq.Builder reqBuilder;
    private final String indexName;

    private YzFetchIndexOperation(Builder builder) {
        this.reqBuilder = builder.reqBuilder;
        this.indexName = builder.indexName;
    }

    @Override
    protected Response convert(List<RiakYokozunaPB.RpbYokozunaIndexGetResp> rawResponse) {
        RiakYokozunaPB.RpbYokozunaIndexGetResp response = rawResponse.get(0);
        ArrayList<YokozunaIndex> indexList = new ArrayList<YokozunaIndex>(response.getIndexCount());
        for (RiakYokozunaPB.RpbYokozunaIndex pbIndex : response.getIndexList()) {
            indexList.add(new YokozunaIndex(pbIndex.getName().toStringUtf8(), pbIndex.getSchema().toStringUtf8()).withNVal(pbIndex.getNVal()));
        }
        return new Response(indexList);
    }

    @Override
    protected RiakMessage createChannelMessage() {
        RiakYokozunaPB.RpbYokozunaIndexGetReq req = this.reqBuilder.build();
        return new RiakMessage(54, req.toByteArray());
    }

    @Override
    protected RiakYokozunaPB.RpbYokozunaIndexGetResp decode(RiakMessage rawMessage) {
        Operations.checkPBMessageType(rawMessage, (byte)55);
        try {
            return RiakYokozunaPB.RpbYokozunaIndexGetResp.parseFrom(rawMessage.getData());
        }
        catch (InvalidProtocolBufferException ex) {
            throw new IllegalArgumentException("Invalid message received", ex);
        }
    }

    @Override
    public String getQueryInfo() {
        return this.indexName;
    }

    public static class Response {
        private final List<YokozunaIndex> indexList;

        Response(List<YokozunaIndex> indexList) {
            this.indexList = indexList;
        }

        public List<YokozunaIndex> getIndexes() {
            return this.indexList;
        }
    }

    public static class Builder {
        private final RiakYokozunaPB.RpbYokozunaIndexGetReq.Builder reqBuilder = RiakYokozunaPB.RpbYokozunaIndexGetReq.newBuilder();
        private String indexName = "All Indexes";

        public Builder withIndexName(String indexName) {
            if (null == indexName || indexName.length() == 0) {
                throw new IllegalArgumentException("Index name cannot be null or zero length");
            }
            this.reqBuilder.setName(ByteString.copyFromUtf8((String)indexName));
            this.indexName = indexName;
            return this;
        }

        public YzFetchIndexOperation build() {
            return new YzFetchIndexOperation(this);
        }
    }
}

