/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations.ts;

import com.basho.riak.client.core.operations.TTBFutureOperation;
import com.basho.riak.client.core.operations.ts.TTBConverters;
import com.basho.riak.client.core.query.timeseries.QueryResult;
import com.basho.riak.protobuf.RiakTsPB;
import com.google.protobuf.ByteString;
import java.util.List;

public class QueryOperation
extends TTBFutureOperation<QueryResult, String> {
    private final String queryText;

    private QueryOperation(Builder builder) {
        super(new TTBConverters.QueryEncoder(builder), new TTBConverters.QueryResultDecoder());
        this.queryText = builder.queryText;
    }

    @Override
    protected QueryResult convert(List<byte[]> responses) {
        byte[] response = this.checkAndGetSingleResponse(responses);
        return (QueryResult)this.responseParser.parseFrom(response);
    }

    @Override
    public String getQueryInfo() {
        return this.queryText;
    }

    public static class Builder {
        private final String queryText;
        private final RiakTsPB.TsInterpolation.Builder interpolationBuilder = RiakTsPB.TsInterpolation.newBuilder();

        public Builder(String queryText) {
            if (queryText == null || queryText.length() == 0) {
                throw new IllegalArgumentException("QueryText cannot be null or empty");
            }
            this.queryText = queryText;
            this.interpolationBuilder.setBase(ByteString.copyFromUtf8((String)queryText));
        }

        public String getQueryText() {
            return this.queryText;
        }

        public QueryOperation build() {
            return new QueryOperation(this);
        }
    }
}

