/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations.ts;

import com.basho.riak.client.core.codec.InvalidTermToBinaryException;
import com.basho.riak.client.core.codec.TermToBinaryCodec;
import com.basho.riak.client.core.operations.TTBFutureOperation;
import com.basho.riak.client.core.operations.ts.FetchOperation;
import com.basho.riak.client.core.operations.ts.QueryOperation;
import com.basho.riak.client.core.operations.ts.StoreOperation;
import com.basho.riak.client.core.query.timeseries.Cell;
import com.basho.riak.client.core.query.timeseries.QueryResult;
import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpOutputStream;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TTBConverters {
    private static Logger logger = LoggerFactory.getLogger(TTBConverters.class);

    TTBConverters() {
    }

    static class QueryResultDecoder
    implements TTBFutureOperation.TTBParser<QueryResult> {
        QueryResultDecoder() {
        }

        @Override
        public QueryResult parseFrom(byte[] data) {
            QueryResult rv;
            try {
                rv = TermToBinaryCodec.decodeTsResultResponse(data);
            }
            catch (InvalidTermToBinaryException | OtpErlangDecodeException ex) {
                String errorMsg = "Error decoding Riak TTB response";
                logger.error("Error decoding Riak TTB response", ex);
                throw new IllegalArgumentException("Error decoding Riak TTB response", ex);
            }
            return rv;
        }
    }

    static class VoidDecoder
    implements TTBFutureOperation.TTBParser<Void> {
        VoidDecoder() {
        }

        @Override
        public Void parseFrom(byte[] data) {
            return null;
        }
    }

    static class QueryEncoder
    extends BuilderTTBEncoder<QueryOperation.Builder> {
        QueryEncoder(QueryOperation.Builder builder) {
            super(builder);
        }

        @Override
        OtpOutputStream buildMessage() {
            return TermToBinaryCodec.encodeTsQueryRequest(((QueryOperation.Builder)this.builder).getQueryText());
        }
    }

    static class FetchEncoder
    extends BuilderTTBEncoder<FetchOperation.Builder> {
        FetchEncoder(FetchOperation.Builder builder) {
            super(builder);
        }

        @Override
        OtpOutputStream buildMessage() {
            LinkedList<Cell> list = new LinkedList<Cell>();
            for (Cell c : ((FetchOperation.Builder)this.builder).getKeyValues()) {
                list.add(c);
            }
            return TermToBinaryCodec.encodeTsGetRequest(((FetchOperation.Builder)this.builder).getTableName(), list, ((FetchOperation.Builder)this.builder).getTimeout());
        }
    }

    static class StoreEncoder
    extends BuilderTTBEncoder<StoreOperation.Builder> {
        StoreEncoder(StoreOperation.Builder builder) {
            super(builder);
        }

        @Override
        OtpOutputStream buildMessage() {
            return TermToBinaryCodec.encodeTsPutRequest(((StoreOperation.Builder)this.builder).getTableName(), ((StoreOperation.Builder)this.builder).getRows());
        }
    }

    private static abstract class BuilderTTBEncoder<T>
    implements TTBFutureOperation.TTBEncoder {
        protected final T builder;

        BuilderTTBEncoder(T builder) {
            this.builder = builder;
        }

        abstract OtpOutputStream buildMessage();

        @Override
        public byte[] build() {
            return this.buildMessage().toByteArray();
        }
    }
}

