/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.indexes;

import com.basho.riak.client.core.query.indexes.IndexType;
import com.basho.riak.client.core.query.indexes.RiakIndex;
import com.basho.riak.client.core.util.BinaryValue;
import java.nio.charset.Charset;

public class LongIntIndex
extends RiakIndex<Long> {
    private LongIntIndex(Name name) {
        super(name);
    }

    @Override
    protected BinaryValue convert(Long value) {
        return BinaryValue.unsafeCreate(value.toString().getBytes(Charset.forName("UTF-8")));
    }

    @Override
    protected Long convert(BinaryValue value) {
        return Long.valueOf(value.toString(Charset.forName("UTF-8")));
    }

    public static Name named(String name) {
        return new Name(name);
    }

    public static class Name
    extends RiakIndex.Name<LongIntIndex> {
        Name(String name) {
            super(name, IndexType.INT);
        }

        @Override
        LongIntIndex createIndex() {
            return new LongIntIndex(this);
        }
    }
}

