/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.timeseries;

import com.basho.riak.client.core.query.timeseries.Cell;
import com.basho.riak.client.core.query.timeseries.ColumnDescription;
import com.basho.riak.client.core.query.timeseries.FullColumnDescription;
import com.basho.riak.client.core.query.timeseries.QueryResult;
import com.basho.riak.client.core.query.timeseries.Row;
import com.basho.riak.protobuf.RiakTsPB;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public final class CollectionConverters {
    private CollectionConverters() {
    }

    public static Collection<RiakTsPB.TsColumnDescription> convertColumnDescriptionsToPb(Collection<ColumnDescription> columns) {
        ArrayList<RiakTsPB.TsColumnDescription> pbColumns = new ArrayList<RiakTsPB.TsColumnDescription>(columns.size());
        for (ColumnDescription column : columns) {
            pbColumns.add(CollectionConverters.convertColumnDescriptionToPb(column));
        }
        return pbColumns;
    }

    private static RiakTsPB.TsColumnDescription convertColumnDescriptionToPb(ColumnDescription column) {
        RiakTsPB.TsColumnDescription.Builder columnBuilder = RiakTsPB.TsColumnDescription.newBuilder();
        columnBuilder.setName(ByteString.copyFromUtf8((String)column.getName()));
        columnBuilder.setType(RiakTsPB.TsColumnType.valueOf(column.getType().ordinal()));
        return columnBuilder.build();
    }

    public static List<ColumnDescription> convertPBColumnDescriptions(List<RiakTsPB.TsColumnDescription> pbColumns) {
        if (pbColumns == null) {
            return Collections.emptyList();
        }
        ArrayList<ColumnDescription> columns = new ArrayList<ColumnDescription>(pbColumns.size());
        for (RiakTsPB.TsColumnDescription pbColumn : pbColumns) {
            ColumnDescription columnDescription = CollectionConverters.convertPBColumnDescription(pbColumn);
            columns.add(columnDescription);
        }
        return columns;
    }

    private static ColumnDescription convertPBColumnDescription(RiakTsPB.TsColumnDescription pbColumn) {
        String name = pbColumn.getName().toStringUtf8();
        ColumnDescription.ColumnType type = ColumnDescription.ColumnType.values()[pbColumn.getType().getNumber()];
        return new ColumnDescription(name, type);
    }

    public static List<FullColumnDescription> convertDescribeQueryResultToColumnDescriptions(QueryResult queryResult) {
        ArrayList<FullColumnDescription> fullColumnDescriptions = new ArrayList<FullColumnDescription>(queryResult.getRowsCount());
        for (Row row : queryResult) {
            fullColumnDescriptions.add(CollectionConverters.convertDescribeResultRowToFullColumnDescription(row));
        }
        return fullColumnDescriptions;
    }

    private static FullColumnDescription convertDescribeResultRowToFullColumnDescription(Row row) {
        List<Cell> cells = row.getCellsCopy();
        assert (CollectionConverters.DescribeFnRowResultIsValid(cells));
        String name = cells.get(0).getVarcharAsUTF8String();
        String typeString = cells.get(1).getVarcharAsUTF8String();
        boolean isNullable = cells.get(2).getBoolean();
        boolean isPartitionKeyMember = cells.get(3) != null;
        boolean isLocalKeyMember = cells.get(4) != null;
        Integer partitionKeyOrdinal = isPartitionKeyMember ? Integer.valueOf(new Long(cells.get(3).getLong()).intValue()) : null;
        Integer localKeyOrdinal = isLocalKeyMember ? Integer.valueOf(new Long(cells.get(4).getLong()).intValue()) : null;
        ColumnDescription.ColumnType type = ColumnDescription.ColumnType.valueOf(typeString.toUpperCase(Locale.ENGLISH));
        return new FullColumnDescription(name, type, isNullable, partitionKeyOrdinal, localKeyOrdinal);
    }

    private static boolean DescribeFnRowResultIsValid(List<Cell> cells) {
        return cells.size() == 5 && cells.get(0).hasVarcharValue() && cells.get(1).hasVarcharValue() && cells.get(2).hasBoolean() && cells.get(3) != null ? cells.get(3).hasLong() : (cells.get(4) != null ? cells.get(4).hasLong() : true);
    }
}

