/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.timeseries;

import com.basho.riak.client.core.query.timeseries.CollectionConverters;
import com.basho.riak.client.core.query.timeseries.FlatteningIterable;
import com.basho.riak.client.core.query.timeseries.QueryResult;
import com.basho.riak.client.core.query.timeseries.TableDefinition;
import com.basho.riak.protobuf.RiakTsPB;
import java.util.Iterator;
import java.util.List;

public final class PbResultFactory {
    private PbResultFactory() {
    }

    public static QueryResult convertPbQueryResp(RiakTsPB.TsQueryResp response) {
        if (response == null) {
            return QueryResult.EMPTY;
        }
        return new QueryResult(response.getColumnsList(), response.getRowsList());
    }

    public static QueryResult convertPbGetResp(RiakTsPB.TsGetResp response) {
        if (response == null) {
            return QueryResult.EMPTY;
        }
        return new QueryResult(response.getColumnsList(), response.getRowsList());
    }

    public static QueryResult convertPbListKeysResp(List<RiakTsPB.TsListKeysResp> responseChunks) {
        if (responseChunks == null) {
            return QueryResult.EMPTY;
        }
        int totalKeyCount = 0;
        for (RiakTsPB.TsListKeysResp responseChunk : responseChunks) {
            totalKeyCount += responseChunk.getKeysCount();
        }
        FlatteningIterable<RiakTsPB.TsListKeysResp, RiakTsPB.TsRow> flatIterable = new FlatteningIterable<RiakTsPB.TsListKeysResp, RiakTsPB.TsRow>(responseChunks, new FlatteningIterable.InnerIterableProvider<RiakTsPB.TsListKeysResp, RiakTsPB.TsRow>(){

            @Override
            public Iterator<RiakTsPB.TsRow> getInnerIterator(RiakTsPB.TsListKeysResp provider) {
                return provider.getKeysList().iterator();
            }
        });
        return new QueryResult(flatIterable, totalKeyCount);
    }

    public static TableDefinition convertDescribeResp(String tableName, RiakTsPB.TsQueryResp response) {
        if (response == null || response.getRowsCount() == 0) {
            return null;
        }
        QueryResult intermediaryQueryResult = new QueryResult(response.getColumnsList(), response.getRowsList());
        return new TableDefinition(tableName, CollectionConverters.convertDescribeQueryResultToColumnDescriptions(intermediaryQueryResult));
    }
}

