/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api;

import com.basho.riak.client.api.RiakCommand;
import com.basho.riak.client.api.commands.CoreFutureAdapter;
import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;

public abstract class GenericRiakCommand<R, I, CoreR, CoreI>
extends RiakCommand<R, I> {
    protected abstract FutureOperation<CoreR, ?, CoreI> buildCoreOperation();

    @Override
    protected RiakFuture<R, I> executeAsync(RiakCluster cluster) {
        final FutureOperation<CoreR, ?, CoreI> coreOperation = this.buildCoreOperation();
        assert (coreOperation != null);
        RiakFuture<CoreR, CoreI> coreFuture = cluster.execute(coreOperation);
        assert (coreFuture != null);
        CoreFutureAdapter future = new CoreFutureAdapter<R, I, CoreR, CoreI>(coreFuture){

            @Override
            protected R convertResponse(CoreR coreResponse) {
                return GenericRiakCommand.this.convertResponse(coreOperation, coreResponse);
            }

            @Override
            protected I convertQueryInfo(CoreI coreQueryInfo) {
                return GenericRiakCommand.this.convertInfo(coreQueryInfo);
            }
        };
        coreFuture.addListener(future);
        return future;
    }

    protected abstract R convertResponse(FutureOperation<CoreR, ?, CoreI> var1, CoreR var2);

    protected abstract I convertInfo(CoreI var1);

    public static abstract class GenericRiakCommandWithSameInfo<R, I, CoreR>
    extends GenericRiakCommand<R, I, CoreR, I> {
        @Override
        protected I convertInfo(I coreInfo) {
            return coreInfo;
        }
    }
}

