/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api;

import com.basho.riak.client.api.RiakCommand;
import com.basho.riak.client.api.StreamableRiakCommand;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.RiakNode;
import com.basho.riak.client.core.util.HostAndPort;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RiakClient {
    private final RiakCluster cluster;

    public RiakClient(RiakCluster cluster) {
        this.cluster = cluster;
    }

    public static RiakClient newClient() throws UnknownHostException {
        RiakNode.Builder builder = new RiakNode.Builder().withMinConnections(10);
        RiakCluster cluster = new RiakCluster.Builder(builder.build()).build();
        cluster.start();
        return new RiakClient(cluster);
    }

    public static RiakClient newClient(int port, String ... remoteAddresses) throws UnknownHostException {
        return RiakClient.newClient(port, Arrays.asList(remoteAddresses));
    }

    public static RiakClient newClient(List<String> remoteAddresses) throws UnknownHostException {
        return RiakClient.newClient(8087, remoteAddresses);
    }

    public static RiakClient newClient(String ... remoteAddresses) throws UnknownHostException {
        return RiakClient.newClient(8087, Arrays.asList(remoteAddresses));
    }

    public static RiakClient newClient(int port, List<String> remoteAddresses) throws UnknownHostException {
        RiakNode.Builder builder = RiakClient.createDefaultNodeBuilder().withRemotePort(port);
        return RiakClient.newClient(builder, remoteAddresses);
    }

    public static RiakClient newClient(InetSocketAddress ... addresses) throws UnknownHostException {
        ArrayList<String> remoteAddresses = new ArrayList<String>(addresses.length);
        for (InetSocketAddress addy : addresses) {
            remoteAddresses.add(String.format("%s:%s", addy.getHostName(), addy.getPort()));
        }
        return RiakClient.newClient(RiakClient.createDefaultNodeBuilder(), remoteAddresses);
    }

    public static RiakClient newClient(RiakNode.Builder nodeBuilder, List<String> addresses) throws UnknownHostException {
        RiakCluster cluster = new RiakCluster.Builder(nodeBuilder, addresses).build();
        cluster.start();
        return new RiakClient(cluster);
    }

    public static RiakClient newClient(RiakNode.Builder nodeBuilder, String ... addresses) throws UnknownHostException {
        return RiakClient.newClient(nodeBuilder, Arrays.asList(addresses));
    }

    public static RiakClient newClient(Collection<HostAndPort> hosts) throws UnknownHostException {
        return RiakClient.newClient(hosts, RiakClient.createDefaultNodeBuilder());
    }

    public static RiakClient newClient(Collection<HostAndPort> hosts, RiakNode.Builder nodeBuilder) throws UnknownHostException {
        RiakCluster cluster = new RiakCluster.Builder(hosts, nodeBuilder).build();
        cluster.start();
        return new RiakClient(cluster);
    }

    public static RiakNode.Builder createDefaultNodeBuilder() {
        return new RiakNode.Builder().withMinConnections(10);
    }

    public <T, S> T execute(RiakCommand<T, S> command) throws ExecutionException, InterruptedException {
        return command.execute(this.cluster);
    }

    public <T, S> T execute(RiakCommand<T, S> command, long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        return command.execute(this.cluster, timeout, unit);
    }

    public <T, S> RiakFuture<T, S> executeAsync(RiakCommand<T, S> command) {
        return command.executeAsync(this.cluster);
    }

    public <I extends StreamableRiakCommand.StreamableResponse, S> RiakFuture<I, S> executeAsyncStreaming(StreamableRiakCommand<I, S, ?, ?> command, int timeoutMS) {
        return command.executeAsyncStreaming(this.cluster, timeoutMS);
    }

    public Future<Boolean> shutdown() {
        return this.cluster.shutdown();
    }

    public RiakCluster getRiakCluster() {
        return this.cluster;
    }

    public void cleanup() {
        this.cluster.cleanup();
    }
}

