/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api;

import com.basho.riak.client.api.GenericRiakCommand;
import com.basho.riak.client.api.commands.ChunkedResponseIterator;
import com.basho.riak.client.api.commands.ImmediateCoreFutureAdapter;
import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.PBStreamingFutureOperation;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.StreamingRiakFuture;
import java.util.Iterator;

public abstract class StreamableRiakCommand<R extends StreamableResponse, I, CoreR, CoreI>
extends GenericRiakCommand<R, I, CoreR, CoreI> {
    protected abstract R createResponse(int var1, StreamingRiakFuture<CoreR, CoreI> var2);

    protected abstract PBStreamingFutureOperation<CoreR, ?, CoreI> buildCoreOperation(boolean var1);

    @Override
    protected final FutureOperation<CoreR, ?, CoreI> buildCoreOperation() {
        return this.buildCoreOperation(false);
    }

    protected final RiakFuture<R, I> executeAsyncStreaming(RiakCluster cluster, int timeout) {
        final PBStreamingFutureOperation<CoreR, ?, CoreI> coreOperation = this.buildCoreOperation(true);
        StreamingRiakFuture<CoreR, CoreI> coreFuture = cluster.execute(coreOperation);
        R r = this.createResponse(timeout, coreFuture);
        ImmediateCoreFutureAdapter future = new ImmediateCoreFutureAdapter<R, I, CoreR, CoreI>(coreFuture, (StreamableResponse)r){

            @Override
            protected R convertResponse(CoreR response) {
                return (StreamableResponse)StreamableRiakCommand.this.convertResponse(coreOperation, response);
            }

            @Override
            protected I convertQueryInfo(CoreI coreQueryInfo) {
                return StreamableRiakCommand.this.convertInfo(coreQueryInfo);
            }
        };
        coreFuture.addListener(future);
        return future;
    }

    public static abstract class StreamableResponse<T, S>
    implements Iterable<T> {
        protected ChunkedResponseIterator<T, ?, S> chunkedResponseIterator;

        protected StreamableResponse(ChunkedResponseIterator<T, ?, S> chunkedResponseIterator) {
            this.chunkedResponseIterator = chunkedResponseIterator;
        }

        protected StreamableResponse() {
        }

        public boolean isStreaming() {
            return this.chunkedResponseIterator != null;
        }

        @Override
        public Iterator<T> iterator() {
            if (this.isStreaming()) {
                assert (this.chunkedResponseIterator != null);
                return this.chunkedResponseIterator;
            }
            throw new UnsupportedOperationException("Iterating is only supported for streamable response");
        }
    }

    public static abstract class StreamableRiakCommandWithSameInfo<R extends StreamableResponse, I, CoreR>
    extends StreamableRiakCommand<R, I, CoreR, I> {
        @Override
        protected I convertInfo(I coreInfo) {
            return coreInfo;
        }
    }
}

