/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands;

import com.basho.riak.client.core.StreamingRiakFuture;
import com.basho.riak.client.core.util.BinaryValue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TransferQueue;
import java.util.function.Function;

public class ChunkedResponseIterator<FinalT, ChunkT extends Iterable<CoreT>, CoreT>
implements Iterator<FinalT> {
    private final int timeout;
    private volatile BinaryValue continuation = null;
    private final StreamingRiakFuture<ChunkT, ?> coreFuture;
    private final TransferQueue<ChunkT> chunkQueue;
    private final Function<CoreT, FinalT> createNext;
    private final Function<ChunkT, Iterator<CoreT>> getNextIterator;
    private final Function<ChunkT, BinaryValue> getContinuationFn;
    protected Iterator<CoreT> currentIterator = null;

    public ChunkedResponseIterator(StreamingRiakFuture<ChunkT, ?> coreFuture, int pollTimeout, Function<CoreT, FinalT> createNextFn, Function<ChunkT, Iterator<CoreT>> getNextIteratorFn) {
        this(coreFuture, pollTimeout, createNextFn, getNextIteratorFn, x -> null);
    }

    public ChunkedResponseIterator(StreamingRiakFuture<ChunkT, ?> coreFuture, int pollTimeout, Function<CoreT, FinalT> createNextFn, Function<ChunkT, Iterator<CoreT>> getNextIteratorFn, Function<ChunkT, BinaryValue> getContinuationFn) {
        this.timeout = pollTimeout;
        this.coreFuture = coreFuture;
        this.chunkQueue = coreFuture.getResultsQueue();
        this.createNext = createNextFn;
        this.getNextIterator = getNextIteratorFn;
        this.getContinuationFn = getContinuationFn;
        this.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        boolean interrupted = Thread.interrupted();
        Boolean dataLoaded = null;
        try {
            while (!this.currentIteratorHasNext() && dataLoaded == null) {
                try {
                    dataLoaded = this.tryLoadNextChunkIterator();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
            }
            boolean bl = this.currentIteratorHasNext();
            return bl;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean currentIteratorHasNext() {
        return this.currentIterator != null && this.currentIterator.hasNext();
    }

    private boolean possibleChunksRemaining() {
        return !this.coreFuture.isDone() || !this.chunkQueue.isEmpty();
    }

    public boolean hasContinuation() {
        return this.continuation != null || this.possibleChunksRemaining();
    }

    public BinaryValue getContinuation() {
        return this.continuation;
    }

    @Override
    public FinalT next() {
        if (this.hasNext()) {
            return this.createNext.apply(this.currentIterator.next());
        }
        throw new NoSuchElementException();
    }

    private boolean tryLoadNextChunkIterator() throws InterruptedException {
        this.currentIterator = null;
        boolean populatedChunkLoaded = false;
        while (!populatedChunkLoaded && this.possibleChunksRemaining()) {
            Iterable nextChunk = (Iterable)this.chunkQueue.poll(this.timeout, TimeUnit.MILLISECONDS);
            if (nextChunk == null) continue;
            this.currentIterator = this.getNextIterator.apply(nextChunk);
            populatedChunkLoaded = this.currentIteratorHasNext();
            this.loadContinuation(nextChunk);
        }
        return populatedChunkLoaded;
    }

    private void loadContinuation(ChunkT nextChunk) {
        BinaryValue fetchedContinuation = this.getContinuationFn.apply(nextChunk);
        if (this.continuation == null && fetchedContinuation != null) {
            this.continuation = fetchedContinuation;
        }
    }
}

