/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.buckets;

import com.basho.riak.client.api.StreamableRiakCommand;
import com.basho.riak.client.api.commands.ChunkedResponseIterator;
import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.StreamingRiakFuture;
import com.basho.riak.client.core.operations.ListBucketsOperation;
import com.basho.riak.client.core.query.ConvertibleIterator;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.util.BinaryValue;
import java.util.Iterator;
import java.util.List;

public final class ListBuckets
extends StreamableRiakCommand.StreamableRiakCommandWithSameInfo<Response, BinaryValue, ListBucketsOperation.Response> {
    private final int timeout;
    private final BinaryValue type;

    ListBuckets(Builder builder) {
        this.timeout = builder.timeout;
        this.type = builder.type;
    }

    @Override
    protected Response convertResponse(FutureOperation<ListBucketsOperation.Response, ?, BinaryValue> request, ListBucketsOperation.Response coreResponse) {
        return new Response(this.type, coreResponse.getBuckets());
    }

    @Override
    protected Response createResponse(int timeout, StreamingRiakFuture<ListBucketsOperation.Response, BinaryValue> coreFuture) {
        return new Response(this.type, timeout, coreFuture);
    }

    protected ListBucketsOperation buildCoreOperation(boolean streamResults) {
        ListBucketsOperation.Builder builder = new ListBucketsOperation.Builder();
        if (this.timeout > 0) {
            builder.withTimeout(this.timeout);
        }
        if (this.type != null) {
            builder.withBucketType(this.type);
        }
        builder.streamResults(streamResults);
        return builder.build();
    }

    public static class Builder {
        private int timeout;
        private final BinaryValue type;

        public Builder(String type) {
            this.type = BinaryValue.create(type);
        }

        public Builder(BinaryValue type) {
            this.type = type;
        }

        public Builder withTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public ListBuckets build() {
            return new ListBuckets(this);
        }
    }

    public static class Response
    extends StreamableRiakCommand.StreamableResponse<Namespace, BinaryValue> {
        private final BinaryValue type;
        private final List<BinaryValue> buckets;

        Response(BinaryValue type, int pollTimeout, StreamingRiakFuture<ListBucketsOperation.Response, BinaryValue> coreFuture) {
            super(new ChunkedResponseIterator<Namespace, ListBucketsOperation.Response, BinaryValue>(coreFuture, pollTimeout, bucketName -> new Namespace(type, (BinaryValue)bucketName), response -> response.getBuckets().iterator()));
            this.type = type;
            this.buckets = null;
        }

        public Response(BinaryValue type, List<BinaryValue> buckets) {
            this.type = type;
            this.buckets = buckets;
        }

        @Override
        public Iterator<Namespace> iterator() {
            if (this.isStreaming()) {
                return super.iterator();
            }
            assert (this.buckets != null);
            return new ConvertibleIterator<BinaryValue, Namespace>(this.buckets.iterator()){

                @Override
                protected Namespace convert(BinaryValue bucket) {
                    return new Namespace(type, bucket);
                }
            };
        }
    }
}

