/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.buckets;

import com.basho.riak.client.api.AsIsRiakCommand;
import com.basho.riak.client.core.operations.StoreBucketPropsOperation;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.query.functions.Function;

public final class StoreBucketProperties
extends AsIsRiakCommand<Void, Namespace> {
    private final Namespace namespace;
    private final Boolean allowMulti;
    private final String backend;
    private final Boolean basicQuorum;
    private final Long bigVClock;
    private final Function chashkeyFunction;
    private final Boolean lastWriteWins;
    private final Function linkWalkFunction;
    private final Integer rw;
    private final Integer dw;
    private final Integer w;
    private final Integer r;
    private final Integer pr;
    private final Integer pw;
    private final Boolean notFoundOk;
    private final Function preCommitHook;
    private final Function postCommitHook;
    private final Long oldVClock;
    private final Long youngVClock;
    private final Long smallVClock;
    private final Integer nval;
    private final Boolean legacySearch;
    private final String searchIndex;
    private final Integer hllPrecision;

    StoreBucketProperties(Builder builder) {
        this.namespace = builder.namespace;
        this.allowMulti = builder.allowMulti;
        this.backend = builder.backend;
        this.bigVClock = builder.bigVClock;
        this.chashkeyFunction = builder.chashkeyFunction;
        this.lastWriteWins = builder.lastWriteWins;
        this.basicQuorum = builder.basicQuorum;
        this.linkWalkFunction = builder.linkWalkFunction;
        this.rw = builder.rw;
        this.dw = builder.dw;
        this.w = builder.w;
        this.pr = builder.pr;
        this.pw = builder.pw;
        this.r = builder.r;
        this.notFoundOk = builder.notFoundOk;
        this.preCommitHook = builder.preCommitHook;
        this.postCommitHook = builder.postCommitHook;
        this.oldVClock = builder.oldVClock;
        this.youngVClock = builder.youngVClock;
        this.smallVClock = builder.smallVClock;
        this.nval = builder.nval;
        this.legacySearch = builder.legacySearch;
        this.searchIndex = builder.searchIndex;
        this.hllPrecision = builder.hllPrecision;
    }

    protected StoreBucketPropsOperation buildCoreOperation() {
        StoreBucketPropsOperation.Builder builder = new StoreBucketPropsOperation.Builder(this.namespace);
        if (this.allowMulti != null) {
            builder.withAllowMulti(this.allowMulti);
        }
        if (this.backend != null) {
            builder.withBackend(this.backend);
        }
        if (this.basicQuorum != null) {
            builder.withBasicQuorum(this.basicQuorum);
        }
        if (this.bigVClock != null) {
            builder.withBigVClock(this.bigVClock);
        }
        if (this.chashkeyFunction != null) {
            builder.withChashkeyFunction(this.chashkeyFunction);
        }
        if (this.lastWriteWins != null) {
            builder.withLastWriteWins(this.lastWriteWins);
        }
        if (this.linkWalkFunction != null) {
            builder.withLinkwalkFunction(this.linkWalkFunction);
        }
        if (this.rw != null) {
            builder.withRw(this.rw);
        }
        if (this.dw != null) {
            builder.withDw(this.dw);
        }
        if (this.w != null) {
            builder.withW(this.w);
        }
        if (this.r != null) {
            builder.withR(this.r);
        }
        if (this.pr != null) {
            builder.withPr(this.pr);
        }
        if (this.pw != null) {
            builder.withPw(this.pw);
        }
        if (this.notFoundOk != null) {
            builder.withNotFoundOk(this.notFoundOk);
        }
        if (this.preCommitHook != null) {
            builder.withPrecommitHook(this.preCommitHook);
        }
        if (this.postCommitHook != null) {
            builder.withPostcommitHook(this.postCommitHook);
        }
        if (this.oldVClock != null) {
            builder.withOldVClock(this.oldVClock);
        }
        if (this.youngVClock != null) {
            builder.withYoungVClock(this.youngVClock);
        }
        if (this.smallVClock != null) {
            builder.withSmallVClock(this.smallVClock);
        }
        if (this.nval != null) {
            builder.withNVal(this.nval);
        }
        if (this.legacySearch != null) {
            builder.withLegacyRiakSearchEnabled(this.legacySearch);
        }
        if (this.searchIndex != null) {
            builder.withSearchIndex(this.searchIndex);
        }
        if (this.hllPrecision != null) {
            builder.withHllPrecision(this.hllPrecision);
        }
        return builder.build();
    }

    public static class Builder {
        private final Namespace namespace;
        private Boolean allowMulti;
        private String backend;
        private Boolean basicQuorum;
        private Long bigVClock;
        private Function chashkeyFunction;
        private Boolean lastWriteWins;
        private Function linkWalkFunction;
        private Integer rw;
        private Integer dw;
        private Integer w;
        private Integer r;
        private Integer pr;
        private Integer pw;
        private Boolean notFoundOk;
        private Function preCommitHook;
        private Function postCommitHook;
        private Long oldVClock;
        private Long youngVClock;
        private Long smallVClock;
        private Integer nval;
        private Boolean legacySearch;
        private String searchIndex;
        private Integer hllPrecision;

        public Builder(Namespace namespace) {
            if (namespace == null) {
                throw new IllegalArgumentException("Namespace cannot be null");
            }
            this.namespace = namespace;
        }

        public Builder withAllowMulti(boolean allow) {
            this.allowMulti = allow;
            return this;
        }

        public Builder withBackend(String backend) {
            if (null == backend || backend.length() == 0) {
                throw new IllegalArgumentException("Backend can not be null or zero length");
            }
            this.backend = backend;
            return this;
        }

        public Builder withBasicQuorum(boolean use) {
            this.basicQuorum = use;
            return this;
        }

        public Builder withBigVClock(Long bigVClock) {
            this.bigVClock = bigVClock;
            return this;
        }

        public Builder withChashkeyFunction(Function func) {
            this.chashkeyFunction = func;
            return this;
        }

        public Builder withLastWriteWins(boolean wins) {
            this.lastWriteWins = wins;
            return this;
        }

        public Builder withLinkwalkFunction(Function func) {
            this.linkWalkFunction = func;
            return this;
        }

        public Builder withRw(int rw) {
            this.rw = rw;
            return this;
        }

        public Builder withDw(int dw) {
            this.dw = dw;
            return this;
        }

        public Builder withW(int w) {
            this.w = w;
            return this;
        }

        public Builder withR(int r) {
            this.r = r;
            return this;
        }

        public Builder withPr(int pr) {
            this.pr = pr;
            return this;
        }

        public Builder withPw(int pw) {
            this.pw = pw;
            return this;
        }

        public Builder withNotFoundOk(boolean ok) {
            this.notFoundOk = ok;
            return this;
        }

        public Builder withPrecommitHook(Function hook) {
            if (null == hook || hook.isJavascript() && !hook.isNamed()) {
                throw new IllegalArgumentException("Must be a named JS or Erlang function.");
            }
            this.preCommitHook = hook;
            return this;
        }

        public Builder withPostcommitHook(Function hook) {
            this.postCommitHook = hook;
            return this;
        }

        public Builder withOldVClock(Long oldVClock) {
            this.oldVClock = oldVClock;
            return this;
        }

        public Builder withYoungVClock(Long youngVClock) {
            this.youngVClock = youngVClock;
            return this;
        }

        public Builder withSmallVClock(Long smallVClock) {
            this.smallVClock = smallVClock;
            return this;
        }

        public Builder withNVal(int nVal) {
            if (nVal <= 0) {
                throw new IllegalArgumentException("nVal must be >= 1");
            }
            this.nval = nVal;
            return this;
        }

        public Builder withLegacyRiakSearchEnabled(boolean enable) {
            this.legacySearch = enable;
            return this;
        }

        public Builder withSearchIndex(String indexName) {
            if (null == indexName || indexName.length() == 0) {
                throw new IllegalArgumentException("Index name cannot be null or zero length");
            }
            this.searchIndex = indexName;
            return this;
        }

        public Builder withHllPrecision(int precision) {
            if (precision < 4 || precision > 16) {
                throw new IllegalArgumentException("Precision must be between 4 and 16, inclusive.");
            }
            this.hllPrecision = precision;
            return this;
        }

        public StoreBucketProperties build() {
            return new StoreBucketProperties(this);
        }
    }
}

