/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.datatypes;

import com.basho.riak.client.api.commands.datatypes.DatatypeUpdate;
import com.basho.riak.client.core.query.crdt.ops.HllOp;
import com.basho.riak.client.core.util.BinaryValue;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class HllUpdate
implements DatatypeUpdate {
    private final Set<BinaryValue> adds = new HashSet<BinaryValue>();

    public HllUpdate addBinary(BinaryValue element) {
        this.adds.add(element);
        return this;
    }

    public HllUpdate add(String element) {
        this.adds.add(BinaryValue.create(element));
        return this;
    }

    public HllUpdate addAllBinary(Collection<BinaryValue> elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Elements cannot be null");
        }
        for (BinaryValue element : elements) {
            this.adds.add(element);
        }
        return this;
    }

    public HllUpdate addAll(Collection<String> elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Elements cannot be null");
        }
        for (String element : elements) {
            this.adds.add(BinaryValue.create(element));
        }
        return this;
    }

    public Set<BinaryValue> getElementAdds() {
        return this.adds;
    }

    @Override
    public HllOp getOp() {
        return new HllOp(this.adds);
    }

    public String toString() {
        return "Element Adds: " + this.adds;
    }
}

