/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.datatypes;

import com.basho.riak.client.api.commands.datatypes.Context;
import com.basho.riak.client.api.commands.datatypes.CounterUpdate;
import com.basho.riak.client.api.commands.datatypes.DatatypeUpdate;
import com.basho.riak.client.api.commands.datatypes.UpdateDatatype;
import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.operations.DtUpdateOperation;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.query.crdt.types.RiakCounter;
import com.basho.riak.client.core.query.crdt.types.RiakDatatype;
import com.basho.riak.client.core.util.BinaryValue;

public class UpdateCounter
extends UpdateDatatype<RiakCounter, Response> {
    private UpdateCounter(Builder builder) {
        super(builder);
    }

    @Override
    protected Response convertResponse(FutureOperation<DtUpdateOperation.Response, ?, Location> request, DtUpdateOperation.Response coreResponse) {
        RiakCounter counter = null;
        if (coreResponse.hasCrdtElement()) {
            RiakDatatype element = coreResponse.getCrdtElement();
            counter = element.getAsCounter();
        }
        BinaryValue returnedKey = coreResponse.hasGeneratedKey() ? coreResponse.getGeneratedKey() : null;
        Context returnedCtx = null;
        if (coreResponse.hasContext()) {
            returnedCtx = new Context(coreResponse.getContext());
        }
        return new Response(returnedCtx, counter, returnedKey);
    }

    public static final class Builder
    extends UpdateDatatype.Builder<Builder> {
        public Builder(Location location, CounterUpdate update) {
            super(location, (DatatypeUpdate)update);
            if (update == null) {
                throw new IllegalArgumentException("Update cannot be null");
            }
        }

        public Builder(Namespace namespace, CounterUpdate update) {
            super(namespace, (DatatypeUpdate)update);
            if (update == null) {
                throw new IllegalArgumentException("Update cannot be null");
            }
        }

        @Override
        public UpdateCounter build() {
            return new UpdateCounter(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }

    public static final class Response
    extends UpdateDatatype.Response<RiakCounter> {
        private Response(Context context, RiakCounter datatype, BinaryValue generatedKey) {
            super(context, datatype, generatedKey);
        }
    }
}

