/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.datatypes;

import com.basho.riak.client.api.GenericRiakCommand;
import com.basho.riak.client.api.cap.Quorum;
import com.basho.riak.client.api.commands.RiakOption;
import com.basho.riak.client.api.commands.datatypes.Context;
import com.basho.riak.client.api.commands.datatypes.DatatypeUpdate;
import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.operations.DtUpdateOperation;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.query.crdt.types.RiakDatatype;
import com.basho.riak.client.core.util.BinaryValue;
import java.util.HashMap;
import java.util.Map;

public abstract class UpdateDatatype<T extends RiakDatatype, S>
extends GenericRiakCommand.GenericRiakCommandWithSameInfo<S, Location, DtUpdateOperation.Response> {
    protected final Namespace namespace;
    protected final BinaryValue key;
    private final Context ctx;
    private final Map<Option<?>, Object> options = new HashMap();
    private final DatatypeUpdate update;

    UpdateDatatype(Builder builder) {
        this.namespace = builder.namespace;
        this.update = builder.update;
        this.key = builder.key;
        this.ctx = builder.ctx;
        this.options.putAll(builder.options);
    }

    @Override
    protected FutureOperation<DtUpdateOperation.Response, ?, Location> buildCoreOperation() {
        DtUpdateOperation.Builder builder;
        if (this.key != null) {
            Location loc = new Location(this.namespace, this.key);
            builder = new DtUpdateOperation.Builder(loc);
        } else {
            builder = new DtUpdateOperation.Builder(this.namespace);
        }
        if (this.ctx != null) {
            builder.withContext(this.ctx.getValue());
        }
        builder.withOp(this.update.getOp());
        for (Map.Entry<Option<?>, Object> entry : this.options.entrySet()) {
            if (entry.getKey() == Option.DW) {
                builder.withDw(((Quorum)entry.getValue()).getIntValue());
                continue;
            }
            if (entry.getKey() == Option.N_VAL) {
                builder.withNVal((Integer)entry.getValue());
                continue;
            }
            if (entry.getKey() == Option.PW) {
                builder.withPw(((Quorum)entry.getValue()).getIntValue());
                continue;
            }
            if (entry.getKey() == Option.RETURN_BODY) {
                builder.withReturnBody((Boolean)entry.getValue());
                continue;
            }
            if (entry.getKey() == Option.SLOPPY_QUORUM) {
                builder.withSloppyQuorum((Boolean)entry.getValue());
                continue;
            }
            if (entry.getKey() == Option.TIMEOUT) {
                builder.withTimeout((Integer)entry.getValue());
                continue;
            }
            if (entry.getKey() != Option.W) continue;
            builder.withW(((Quorum)entry.getValue()).getIntValue());
        }
        return builder.build();
    }

    public static abstract class Response<T> {
        private final T datatype;
        private final Context context;
        private final BinaryValue generatedKey;

        Response(Context context, T datatype, BinaryValue generatedKey) {
            this.datatype = datatype;
            this.context = context;
            this.generatedKey = generatedKey;
        }

        public boolean hasContext() {
            return this.context != null;
        }

        public Context getContext() {
            return this.context;
        }

        public boolean hasDatatype() {
            return this.datatype != null;
        }

        public T getDatatype() {
            return this.datatype;
        }

        public boolean hasGeneratedKey() {
            return this.generatedKey != null;
        }

        public BinaryValue getGeneratedKey() {
            return this.generatedKey;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private final DatatypeUpdate update;
        private final Namespace namespace;
        private BinaryValue key;
        private Context ctx;
        private Map<Option<?>, Object> options = new HashMap();

        Builder(Location location, DatatypeUpdate update) {
            if (location == null) {
                throw new IllegalArgumentException("Location cannot be null.");
            }
            this.namespace = location.getNamespace();
            this.key = location.getKey();
            if (update == null) {
                throw new IllegalArgumentException("Update cannot be null.");
            }
            this.update = update;
        }

        Builder(Namespace namespace, DatatypeUpdate update) {
            if (namespace == null) {
                throw new IllegalArgumentException("Namespace cannot be null.");
            }
            this.namespace = namespace;
            if (update == null) {
                throw new IllegalArgumentException("Update cannot be null.");
            }
            this.update = update;
        }

        public T withContext(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("Context cannot be null.");
            }
            this.ctx = context;
            return this.self();
        }

        public <U> T withOption(Option<U> option, U value) {
            this.options.put(option, value);
            return this.self();
        }

        public T withTimeout(int timeout) {
            this.withOption(Option.TIMEOUT, timeout);
            return this.self();
        }

        public T withReturnDatatype(boolean returnDatatype) {
            this.withOption(Option.RETURN_BODY, true);
            return this.self();
        }

        protected abstract T self();

        protected abstract UpdateDatatype build();
    }

    public static final class Option<T>
    extends RiakOption<T> {
        public static final Option<Quorum> DW = new Option("DW");
        public static final Option<Integer> N_VAL = new Option("N_VAL");
        public static final Option<Quorum> PW = new Option("PW");
        public static final Option<Boolean> RETURN_BODY = new Option("RETURN_BODY");
        public static final Option<Boolean> SLOPPY_QUORUM = new Option("SLOPPY_QUORUM");
        public static final Option<Integer> TIMEOUT = new Option("TIMEOUT");
        public static final Option<Quorum> W = new Option("W");

        public Option(String name) {
            super(name);
        }
    }
}

