/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.datatypes;

import com.basho.riak.client.api.commands.datatypes.Context;
import com.basho.riak.client.api.commands.datatypes.DatatypeUpdate;
import com.basho.riak.client.api.commands.datatypes.HllUpdate;
import com.basho.riak.client.api.commands.datatypes.UpdateDatatype;
import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.operations.DtUpdateOperation;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.query.crdt.types.RiakDatatype;
import com.basho.riak.client.core.query.crdt.types.RiakHll;
import com.basho.riak.client.core.util.BinaryValue;

public class UpdateHll
extends UpdateDatatype<RiakHll, Response> {
    private UpdateHll(Builder builder) {
        super(builder);
    }

    @Override
    protected Response convertResponse(FutureOperation<DtUpdateOperation.Response, ?, Location> request, DtUpdateOperation.Response coreResponse) {
        RiakHll hll = null;
        if (coreResponse.hasCrdtElement()) {
            RiakDatatype element = coreResponse.getCrdtElement();
            hll = element.getAsHll();
        }
        BinaryValue returnedKey = coreResponse.hasGeneratedKey() ? coreResponse.getGeneratedKey() : null;
        Context returnedCtx = null;
        if (coreResponse.hasContext()) {
            returnedCtx = new Context(coreResponse.getContext());
        }
        return new Response(returnedCtx, hll, returnedKey);
    }

    public static class Response
    extends UpdateDatatype.Response<RiakHll> {
        private Response(Context context, RiakHll datatype, BinaryValue generatedKey) {
            super(context, datatype, generatedKey);
        }

        @Override
        public boolean hasContext() {
            return false;
        }

        @Override
        public Context getContext() {
            return null;
        }
    }

    public static class Builder
    extends UpdateDatatype.Builder<Builder> {
        public Builder(Location location, HllUpdate update) {
            super(location, (DatatypeUpdate)update);
            if (update == null) {
                throw new IllegalArgumentException("Update cannot be null");
            }
        }

        public Builder(Namespace namespace, HllUpdate update) {
            super(namespace, (DatatypeUpdate)update);
            if (update == null) {
                throw new IllegalArgumentException("Update cannot be null");
            }
        }

        @Override
        public Builder withContext(Context unused) {
            return this;
        }

        @Override
        public UpdateHll build() {
            return new UpdateHll(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

