/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.datatypes;

import com.basho.riak.client.api.commands.datatypes.Context;
import com.basho.riak.client.api.commands.datatypes.DatatypeUpdate;
import com.basho.riak.client.api.commands.datatypes.MapUpdate;
import com.basho.riak.client.api.commands.datatypes.UpdateDatatype;
import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.operations.DtUpdateOperation;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.query.crdt.types.RiakDatatype;
import com.basho.riak.client.core.query.crdt.types.RiakMap;
import com.basho.riak.client.core.util.BinaryValue;

public class UpdateMap
extends UpdateDatatype<RiakMap, Response> {
    private UpdateMap(Builder builder) {
        super(builder);
    }

    @Override
    protected Response convertResponse(FutureOperation<DtUpdateOperation.Response, ?, Location> request, DtUpdateOperation.Response coreResponse) {
        RiakMap map = null;
        if (coreResponse.hasCrdtElement()) {
            RiakDatatype element = coreResponse.getCrdtElement();
            map = element.getAsMap();
        }
        BinaryValue returnedKey = coreResponse.hasGeneratedKey() ? coreResponse.getGeneratedKey() : null;
        Context returnedCtx = null;
        if (coreResponse.hasContext()) {
            returnedCtx = new Context(coreResponse.getContext());
        }
        return new Response(returnedCtx, map, returnedKey);
    }

    public static final class Builder
    extends UpdateDatatype.Builder<Builder> {
        public Builder(Location location, MapUpdate update) {
            super(location, (DatatypeUpdate)update);
            if (update == null) {
                throw new IllegalArgumentException("Update cannot be null");
            }
        }

        public Builder(Namespace namespace, MapUpdate update) {
            super(namespace, (DatatypeUpdate)update);
            if (update == null) {
                throw new IllegalArgumentException("Update cannot be null");
            }
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateMap build() {
            return new UpdateMap(this);
        }
    }

    public static final class Response
    extends UpdateDatatype.Response<RiakMap> {
        private Response(Context context, RiakMap datatype, BinaryValue generatedKey) {
            super(context, datatype, generatedKey);
        }
    }
}

