/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.datatypes;

import com.basho.riak.client.api.commands.datatypes.Context;
import com.basho.riak.client.api.commands.datatypes.DatatypeUpdate;
import com.basho.riak.client.api.commands.datatypes.SetUpdate;
import com.basho.riak.client.api.commands.datatypes.UpdateDatatype;
import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.operations.DtUpdateOperation;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.query.crdt.types.RiakDatatype;
import com.basho.riak.client.core.query.crdt.types.RiakSet;
import com.basho.riak.client.core.util.BinaryValue;

public class UpdateSet
extends UpdateDatatype<RiakSet, Response> {
    private UpdateSet(Builder builder) {
        super(builder);
    }

    @Override
    protected Response convertResponse(FutureOperation<DtUpdateOperation.Response, ?, Location> request, DtUpdateOperation.Response coreResponse) {
        RiakSet set = null;
        if (coreResponse.hasCrdtElement()) {
            RiakDatatype element = coreResponse.getCrdtElement();
            set = element.getAsSet();
        }
        BinaryValue returnedKey = coreResponse.hasGeneratedKey() ? coreResponse.getGeneratedKey() : null;
        Context returnedCtx = null;
        if (coreResponse.hasContext()) {
            returnedCtx = new Context(coreResponse.getContext());
        }
        return new Response(returnedCtx, set, returnedKey);
    }

    public static class Response
    extends UpdateDatatype.Response<RiakSet> {
        private Response(Context context, RiakSet datatype, BinaryValue generatedKey) {
            super(context, datatype, generatedKey);
        }
    }

    public static class Builder
    extends UpdateDatatype.Builder<Builder> {
        public Builder(Location location, SetUpdate update) {
            super(location, (DatatypeUpdate)update);
            if (update == null) {
                throw new IllegalArgumentException("Update cannot be null");
            }
        }

        public Builder(Namespace namespace, SetUpdate update) {
            super(namespace, (DatatypeUpdate)update);
            if (update == null) {
                throw new IllegalArgumentException("Update cannot be null");
            }
        }

        @Override
        public UpdateSet build() {
            return new UpdateSet(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

