/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.indexes;

import com.basho.riak.client.api.commands.indexes.SecondaryIndexQuery;
import com.basho.riak.client.core.StreamingRiakFuture;
import com.basho.riak.client.core.operations.SecondaryIndexQueryOperation;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.util.BinaryValue;
import java.math.BigInteger;

public class BigIntIndexQuery
extends SecondaryIndexQuery<BigInteger, Response, BigIntIndexQuery> {
    private final SecondaryIndexQuery.IndexConverter<BigInteger> converter = new SecondaryIndexQuery.IndexConverter<BigInteger>(){

        @Override
        public BigInteger convert(BinaryValue input) {
            return new BigInteger(input.toStringUtf8());
        }

        @Override
        public BinaryValue convert(BigInteger input) {
            if (input == null) {
                return null;
            }
            return BinaryValue.createFromUtf8(input.toString());
        }
    };

    @Override
    protected SecondaryIndexQuery.IndexConverter<BigInteger> getConverter() {
        return this.converter;
    }

    protected BigIntIndexQuery(Init<BigInteger, ?> builder) {
        super(builder, Response::new, Response::new);
    }

    public static class Response
    extends SecondaryIndexQuery.Response<BigInteger, SecondaryIndexQuery.Response.Entry<BigInteger>> {
        Response(Namespace queryLocation, SecondaryIndexQuery.IndexConverter<BigInteger> converter, int timeout, StreamingRiakFuture<SecondaryIndexQueryOperation.Response, SecondaryIndexQueryOperation.Query> coreFuture) {
            super(queryLocation, converter, timeout, coreFuture);
        }

        protected Response(Namespace queryLocation, SecondaryIndexQueryOperation.Response coreResponse, SecondaryIndexQuery.IndexConverter<BigInteger> converter) {
            super(queryLocation, coreResponse, converter);
        }
    }

    public static class Builder
    extends Init<BigInteger, Builder> {
        public Builder(Namespace namespace, String indexName, byte[] coverContext) {
            super(namespace, indexName, coverContext);
        }

        public Builder(Namespace namespace, String indexName, BigInteger start, BigInteger end) {
            super(namespace, indexName, start, end);
        }

        public Builder(Namespace namespace, String indexName, BigInteger match) {
            super(namespace, indexName, match);
        }

        @Override
        protected Builder self() {
            return this;
        }

        public BigIntIndexQuery build() {
            return new BigIntIndexQuery(this);
        }
    }

    protected static abstract class Init<S, T extends Init<S, T>>
    extends SecondaryIndexQuery.Init<S, T> {
        public Init(Namespace namespace, String indexName, S start, S end) {
            super(namespace, indexName + (Object)((Object)SecondaryIndexQuery.Type._INT), start, end);
        }

        public Init(Namespace namespace, String indexName, S match) {
            super(namespace, indexName + (Object)((Object)SecondaryIndexQuery.Type._INT), match);
        }

        public Init(Namespace namespace, String indexName, byte[] coverContext) {
            super(namespace, indexName + (Object)((Object)SecondaryIndexQuery.Type._INT), coverContext);
        }

        @Override
        public T withRegexTermFilter(String filter) {
            throw new IllegalArgumentException("Cannot use term filter with _int query");
        }
    }
}

