/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.indexes;

import com.basho.riak.client.api.commands.indexes.SecondaryIndexQuery;
import com.basho.riak.client.core.StreamingRiakFuture;
import com.basho.riak.client.core.operations.SecondaryIndexQueryOperation;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.util.BinaryValue;
import com.basho.riak.client.core.util.DefaultCharset;
import java.nio.charset.Charset;

public class BinIndexQuery
extends SecondaryIndexQuery<String, Response, BinIndexQuery> {
    private final Charset charset;
    private final SecondaryIndexQuery.IndexConverter<String> converter;

    protected BinIndexQuery(Init<String, ?> builder) {
        super(builder, Response::new, Response::new);
        this.charset = ((Init)builder).charset;
        this.converter = new StringIndexConverter();
    }

    @Override
    protected SecondaryIndexQuery.IndexConverter<String> getConverter() {
        return this.converter;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BinIndexQuery that = (BinIndexQuery)o;
        if (!this.charset.equals(that.charset)) {
            return false;
        }
        return this.converter.equals(that.converter);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.charset.hashCode();
        result = 31 * result + this.converter.hashCode();
        return result;
    }

    private class StringIndexConverter
    implements SecondaryIndexQuery.IndexConverter<String> {
        private StringIndexConverter() {
        }

        @Override
        public String convert(BinaryValue input) {
            return input.toString(BinIndexQuery.this.charset);
        }

        @Override
        public BinaryValue convert(String input) {
            if (input == null) {
                return null;
            }
            return BinaryValue.create(input, BinIndexQuery.this.charset);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 0;
        }
    }

    public static class Response
    extends SecondaryIndexQuery.Response<String, SecondaryIndexQuery.Response.Entry<String>> {
        Response(Namespace queryLocation, SecondaryIndexQuery.IndexConverter<String> converter, int timeout, StreamingRiakFuture<SecondaryIndexQueryOperation.Response, SecondaryIndexQueryOperation.Query> coreFuture) {
            super(queryLocation, converter, timeout, coreFuture);
        }

        protected Response(Namespace queryLocation, SecondaryIndexQueryOperation.Response coreResponse, SecondaryIndexQuery.IndexConverter<String> converter) {
            super(queryLocation, coreResponse, converter);
        }
    }

    public static class Builder
    extends Init<String, Builder> {
        public Builder(Namespace namespace, String indexName, byte[] coverContext) {
            super(namespace, indexName, coverContext);
        }

        public Builder(Namespace namespace, String indexName, String start, String end) {
            super(namespace, indexName, start, end);
        }

        public Builder(Namespace namespace, String indexName, String match) {
            super(namespace, indexName, match);
        }

        @Override
        protected Builder self() {
            return this;
        }

        public BinIndexQuery build() {
            return new BinIndexQuery(this);
        }
    }

    protected static abstract class Init<S, T extends Init<S, T>>
    extends SecondaryIndexQuery.Init<S, T> {
        private Charset charset = DefaultCharset.get();

        public Init(Namespace namespace, String indexName, S start, S end) {
            super(namespace, Init.generateIndexName(indexName), start, end);
        }

        public Init(Namespace namespace, String indexName, S match) {
            super(namespace, Init.generateIndexName(indexName), match);
        }

        public Init(Namespace namespace, String indexName, byte[] coverContext) {
            super(namespace, Init.generateIndexName(indexName), coverContext);
        }

        private static String generateIndexName(String baseIndexName) {
            if ("$bucket".equalsIgnoreCase(baseIndexName) || "$key".equalsIgnoreCase(baseIndexName)) {
                return baseIndexName;
            }
            return baseIndexName + (Object)((Object)SecondaryIndexQuery.Type._BIN);
        }

        T withCharacterSet(Charset charset) {
            this.charset = charset;
            return (T)((Init)this.self());
        }
    }
}

